/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.auth.AuthSchemePreferenceResolver;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.endpoint.AwsClientEndpointProvider;
import software.amazon.awssdk.awscore.endpoints.AccountIdEndpointMode;
import software.amazon.awssdk.awscore.endpoints.AccountIdEndpointModeResolver;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.endpointdiscovery.providers.DefaultEndpointDiscoveryProviderChain;
import software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.protocols.json.internal.unmarshall.SdkClientJsonProtocolAdvancedOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadataAdvancedOption;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.dynamodb.DynamoDbBaseClientBuilder;
import software.amazon.awssdk.services.dynamodb.DynamoDbRetryPolicy;
import software.amazon.awssdk.services.dynamodb.auth.scheme.DynamoDbAuthSchemeProvider;
import software.amazon.awssdk.services.dynamodb.auth.scheme.internal.DynamoDbAuthSchemeInterceptor;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointProvider;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.DynamoDbRequestSetEndpointInterceptor;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.DynamoDbResolveEndpointInterceptor;
import software.amazon.awssdk.services.dynamodb.internal.DynamoDbServiceClientConfigurationBuilder;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultDynamoDbBaseClientBuilder<B extends DynamoDbBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    protected boolean endpointDiscoveryEnabled = false;
    private final Map<String, AuthScheme<?>> additionalAuthSchemes = new HashMap();

    DefaultDynamoDbBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "dynamodb";
    }

    protected final String serviceName() {
        return "DynamoDb";
    }

    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)this.defaultEndpointProvider()).option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)this.defaultAuthSchemeProvider(config)).option((ClientOption)SdkClientOption.AUTH_SCHEMES, this.authSchemes()).option((ClientOption)SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, (Object)true));
    }

    protected final SdkClientConfiguration mergeInternalDefaults(SdkClientConfiguration config) {
        return config.merge(c -> {
            c.option((ClientOption)SdkClientOption.INTERNAL_USER_AGENT, (Object)"md/internal");
            c.option((ClientOption)SdkClientOption.DEFAULT_RETRY_MODE, (Object)RetryMode.STANDARD);
        });
    }

    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ArrayList<Object> endpointInterceptors = new ArrayList<Object>();
        endpointInterceptors.add(new DynamoDbAuthSchemeInterceptor());
        endpointInterceptors.add(new DynamoDbResolveEndpointInterceptor());
        endpointInterceptors.add(new DynamoDbRequestSetEndpointInterceptor());
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List interceptors = interceptorFactory.getInterceptors("software/amazon/awssdk/services/dynamodb/execution.interceptors");
        ArrayList additionalInterceptors = new ArrayList();
        interceptors = CollectionUtils.mergeLists(endpointInterceptors, (List)interceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, additionalInterceptors);
        interceptors = CollectionUtils.mergeLists((List)interceptors, (List)((List)config.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS)));
        if (!this.endpointDiscoveryEnabled) {
            DefaultEndpointDiscoveryProviderChain chain = new DefaultEndpointDiscoveryProviderChain(config);
            this.endpointDiscoveryEnabled = chain.resolveEndpointDiscovery();
        }
        SdkClientConfiguration.Builder builder = config.toBuilder();
        builder.lazyOption((ClientOption)SdkClientOption.IDENTITY_PROVIDERS, c -> {
            IdentityProviders.Builder result = IdentityProviders.builder();
            IdentityProvider credentialsIdentityProvider = (IdentityProvider)c.get((AttributeMap.Key)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
            if (credentialsIdentityProvider != null) {
                result.putIdentityProvider(credentialsIdentityProvider);
            }
            return (IdentityProviders)result.build();
        });
        builder.option((ClientOption)SdkClientOption.EXECUTION_INTERCEPTORS, (Object)interceptors);
        builder.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED, (Object)this.endpointDiscoveryEnabled);
        builder.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)DynamoDbRetryPolicy.resolveRetryStrategy(config));
        builder.option((ClientOption)AwsClientOption.ACCOUNT_ID_ENDPOINT_MODE, (Object)this.resolveAccountIdEndpointMode(config));
        builder.lazyOptionIfAbsent((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER, c -> AwsClientEndpointProvider.builder().serviceEndpointOverrideEnvironmentVariable("AWS_ENDPOINT_URL_DYNAMODB").serviceEndpointOverrideSystemProperty("aws.endpointUrlDynamoDb").serviceProfileProperty("dynamodb").serviceEndpointPrefix(this.serviceEndpointPrefix()).defaultProtocol("https").region((Region)c.get((AttributeMap.Key)AwsClientOption.AWS_REGION)).profileFile((Supplier)c.get((AttributeMap.Key)SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName((String)c.get((AttributeMap.Key)SdkClientOption.PROFILE_NAME)).putAdvancedOption(ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT, (Object)((String)c.get((AttributeMap.Key)ServiceMetadataAdvancedOption.DEFAULT_S3_US_EAST_1_REGIONAL_ENDPOINT))).dualstackEnabled((Boolean)c.get((AttributeMap.Key)AwsClientOption.DUALSTACK_ENDPOINT_ENABLED)).fipsEnabled((Boolean)c.get((AttributeMap.Key)AwsClientOption.FIPS_ENDPOINT_ENABLED)).build());
        builder.option((ClientOption)SdkClientJsonProtocolAdvancedOption.ENABLE_FAST_UNMARSHALLER, (Object)true);
        return builder.build();
    }

    protected final String signingName() {
        return "dynamodb";
    }

    private DynamoDbEndpointProvider defaultEndpointProvider() {
        return DynamoDbEndpointProvider.defaultProvider();
    }

    public B authSchemeProvider(DynamoDbAuthSchemeProvider authSchemeProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.AUTH_SCHEME_PROVIDER, (Object)authSchemeProvider);
        return (B)((DynamoDbBaseClientBuilder)this.thisBuilder());
    }

    private DynamoDbAuthSchemeProvider defaultAuthSchemeProvider(SdkClientConfiguration config) {
        AuthSchemePreferenceResolver authSchemePreferenceProvider = AuthSchemePreferenceResolver.builder().profileFile((Supplier)config.option((ClientOption)SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).build();
        List preferences = authSchemePreferenceProvider.resolveAuthSchemePreference();
        if (!preferences.isEmpty()) {
            return DynamoDbAuthSchemeProvider.defaultProvider(preferences);
        }
        return DynamoDbAuthSchemeProvider.defaultProvider();
    }

    public B putAuthScheme(AuthScheme<?> authScheme) {
        this.additionalAuthSchemes.put(authScheme.schemeId(), authScheme);
        return (B)((DynamoDbBaseClientBuilder)this.thisBuilder());
    }

    private Map<String, AuthScheme<?>> authSchemes() {
        HashMap schemes = new HashMap(2 + this.additionalAuthSchemes.size());
        AwsV4AuthScheme awsV4AuthScheme = AwsV4AuthScheme.create();
        schemes.put(awsV4AuthScheme.schemeId(), (AuthScheme<?>)awsV4AuthScheme);
        NoAuthAuthScheme noAuthAuthScheme = NoAuthAuthScheme.create();
        schemes.put(noAuthAuthScheme.schemeId(), (AuthScheme<?>)noAuthAuthScheme);
        schemes.putAll(this.additionalAuthSchemes);
        return schemes;
    }

    public B accountIdEndpointMode(AccountIdEndpointMode accountIdEndpointMode) {
        this.clientConfiguration.option((ClientOption)AwsClientOption.ACCOUNT_ID_ENDPOINT_MODE, (Object)accountIdEndpointMode);
        return (B)((DynamoDbBaseClientBuilder)this.thisBuilder());
    }

    protected SdkClientConfiguration invokePlugins(SdkClientConfiguration config) {
        List<SdkPlugin> internalPlugins = this.internalPlugins(config);
        List externalPlugins = this.plugins();
        if (internalPlugins.isEmpty() && externalPlugins.isEmpty()) {
            return config;
        }
        List plugins = CollectionUtils.mergeLists(internalPlugins, (List)externalPlugins);
        SdkClientConfiguration.Builder configuration = config.toBuilder();
        DynamoDbServiceClientConfigurationBuilder serviceConfigBuilder = new DynamoDbServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private List<SdkPlugin> internalPlugins(SdkClientConfiguration config) {
        return Collections.emptyList();
    }

    private AccountIdEndpointMode resolveAccountIdEndpointMode(SdkClientConfiguration config) {
        AccountIdEndpointMode configuredMode = (AccountIdEndpointMode)config.option((ClientOption)AwsClientOption.ACCOUNT_ID_ENDPOINT_MODE);
        if (configuredMode == null) {
            configuredMode = AccountIdEndpointModeResolver.create().profileFile((Supplier)config.option((ClientOption)SdkClientOption.PROFILE_FILE_SUPPLIER)).profileName((String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)).defaultMode(AccountIdEndpointMode.PREFERRED).resolve();
        }
        return configuredMode;
    }

    protected static void validateClientOptions(SdkClientConfiguration c) {
    }
}

