/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponseMetadata;

public abstract class DynamoDbResponse
extends AwsResponse {
    private final DynamoDbResponseMetadata responseMetadata;

    protected DynamoDbResponse(Builder builder) {
        super((AwsResponse.Builder)builder);
        this.responseMetadata = builder.responseMetadata();
    }

    public DynamoDbResponseMetadata responseMetadata() {
        return this.responseMetadata;
    }

    public static interface Builder
    extends AwsResponse.Builder {
        public DynamoDbResponse build();

        public DynamoDbResponseMetadata responseMetadata();

        public Builder responseMetadata(AwsResponseMetadata var1);
    }

    protected static abstract class BuilderImpl
    extends AwsResponse.BuilderImpl
    implements Builder {
        private DynamoDbResponseMetadata responseMetadata;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DynamoDbResponse response) {
            super((AwsResponse)response);
            this.responseMetadata = response.responseMetadata();
        }

        @Override
        public DynamoDbResponseMetadata responseMetadata() {
            return this.responseMetadata;
        }

        @Override
        public Builder responseMetadata(AwsResponseMetadata responseMetadata) {
            this.responseMetadata = DynamoDbResponseMetadata.create(responseMetadata);
            return this;
        }
    }
}

