/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import org.slf4j.ILoggerFactory;
import org.slf4j.IMarkerFactory;
import org.slf4j.helpers.BasicMarkerFactory;
import org.slf4j.helpers.NOPLoggerFactory;
import org.slf4j.helpers.NOPMDCAdapter;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public final class LegacyServiceProvider
implements SLF4JServiceProvider {
    private ILoggerFactory loggerFactory;
    private IMarkerFactory markerFactory;
    private MDCAdapter mdcAdapter;

    @Override
    public ILoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @Override
    public IMarkerFactory getMarkerFactory() {
        return this.markerFactory;
    }

    @Override
    public MDCAdapter getMDCAdapter() {
        return this.mdcAdapter;
    }

    @Override
    public String getRequestedApiVersion() {
        return "2.0.99";
    }

    @Override
    public void initialize() {
        this.loggerFactory = LegacyServiceProvider.getFactory("org.slf4j.impl.StaticLoggerBinder", "getLoggerFactory", new NOPLoggerFactory());
        this.markerFactory = LegacyServiceProvider.getFactory("org.slf4j.impl.StaticMarkerBinder", "getMarkerFactory", new BasicMarkerFactory());
        this.mdcAdapter = LegacyServiceProvider.getFactory("org.slf4j.impl.StaticMDCBinder", "getMDCA", new NOPMDCAdapter());
    }

    public String toString() {
        return String.format("LegacyServiceProvider[%s, %s, %s]", this.loggerFactory.getClass(), this.markerFactory.getClass(), this.mdcAdapter.getClass());
    }

    private static <T> T getFactory(String bindingClass, String factoryMethod, T defaultValue) {
        try {
            Object loggerBinder;
            Class<?> loggerBinderClass = Class.forName(bindingClass);
            try {
                loggerBinder = loggerBinderClass.getMethod("getSingleton", new Class[0]).invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException ignore) {
                loggerBinder = loggerBinderClass.getField("SINGLETON").get(null);
            }
            return (T)loggerBinder.getClass().getMethod(factoryMethod, new Class[0]).invoke(loggerBinder, new Object[0]);
        }
        catch (ReflectiveOperationException ignore) {
            return defaultValue;
        }
    }
}

