/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ItemResponse;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.DeleteRequest;
import software.amazon.dynamodb.services.local.shared.model.PutRequest;
import software.amazon.dynamodb.services.local.shared.model.WriteRequest;

public class LocalDBOutputConverter {
    public Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> internalToExternalAttributes(Map<String, AttributeValue> attributes) {
        if (attributes == null) {
            return null;
        }
        HashMap<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> out = new HashMap<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>(attributes.size());
        for (Map.Entry<String, AttributeValue> e : attributes.entrySet()) {
            out.put(e.getKey(), this.internalToExternalAttribute(e.getValue()));
        }
        return out;
    }

    private software.amazon.awssdk.services.dynamodb.model.AttributeValue internalToExternalAttribute(AttributeValue value) {
        if (value == null) {
            return null;
        }
        AttributeValue.Builder builder = software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder();
        if (value.getS() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.s(value.getS()).build();
        }
        if (value.getN() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.n(value.getN()).build();
        }
        if (value.getB() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.b(SdkBytes.fromByteBuffer((ByteBuffer)value.getB())).build();
        }
        if (value.isNULL() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.nul(value.isNULL()).build();
        }
        if (value.getBOOL() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.bool(value.getBOOL()).build();
        }
        if (value.getSS() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.ss(value.getSS()).build();
        }
        if (value.getNS() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.ns(value.getNS()).build();
        }
        if (value.getBS() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.bs(value.getBsAsSDKBytes()).build();
        }
        if (value.getL() != null) {
            ArrayList<software.amazon.awssdk.services.dynamodb.model.AttributeValue> lval = new ArrayList<software.amazon.awssdk.services.dynamodb.model.AttributeValue>(value.getL().size());
            for (AttributeValue lv : value.getL()) {
                lval.add(this.internalToExternalAttribute(lv));
            }
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.l(lval).build();
        }
        if (value.getM() != null) {
            return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.m(this.internalToExternalAttributes(value.getM())).build();
        }
        return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)builder.build();
    }

    public Map<String, List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>>> internalToExternalBatchGetResponses(Map<String, List<Map<String, AttributeValue>>> internal) {
        if (internal == null) {
            return null;
        }
        HashMap<String, List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>>> external = new HashMap<String, List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>>>(internal.size());
        for (Map.Entry<String, List<Map<String, AttributeValue>>> e : internal.entrySet()) {
            external.put(e.getKey(), this.internalToExternalItemList(e.getValue()));
        }
        return external;
    }

    public List<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> internalToExternalItemList(List<Map<String, AttributeValue>> internal) {
        if (internal == null) {
            return null;
        }
        ArrayList<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>> external = new ArrayList<Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>>(internal.size());
        for (Map<String, AttributeValue> internalItem : internal) {
            external.add(this.internalToExternalAttributes(internalItem));
        }
        return external;
    }

    public List<ItemResponse> internalToExternalTransactGetItemsResponses(List<Map<String, AttributeValue>> internal) {
        if (internal == null) {
            return null;
        }
        ArrayList<ItemResponse> result = new ArrayList<ItemResponse>(internal.size());
        for (Map<String, AttributeValue> item : internal) {
            result.add((ItemResponse)ItemResponse.builder().item(this.internalToExternalAttributes(item)).build());
        }
        return result;
    }

    public Map<String, KeysAndAttributes> internalToExternalBatchGetRequests(Map<String, software.amazon.dynamodb.services.local.shared.model.KeysAndAttributes> internal) {
        if (internal == null) {
            return null;
        }
        HashMap<String, KeysAndAttributes> external = new HashMap<String, KeysAndAttributes>(internal.size());
        for (Map.Entry<String, software.amazon.dynamodb.services.local.shared.model.KeysAndAttributes> e : internal.entrySet()) {
            KeysAndAttributes.Builder kasBuilder = KeysAndAttributes.builder();
            if (e.getValue().getAttributesToGet() != null) {
                kasBuilder.attributesToGet(e.getValue().getAttributesToGet());
            }
            if (e.getValue().getConsistentRead() != null) {
                kasBuilder.consistentRead(e.getValue().getConsistentRead());
            }
            if (e.getValue().getKeys() != null) {
                kasBuilder.keys(this.internalToExternalItemList(e.getValue().getKeys()));
            }
            if (e.getValue().getExpressionAttributeNames() != null) {
                kasBuilder.expressionAttributeNames(e.getValue().getExpressionAttributeNames());
            }
            if (e.getValue().getProjectionExpression() != null) {
                kasBuilder.projectionExpression(e.getValue().getProjectionExpression());
            }
            external.put(e.getKey(), (KeysAndAttributes)kasBuilder.build());
        }
        return external;
    }

    public Map<String, List<software.amazon.awssdk.services.dynamodb.model.WriteRequest>> internalToExternalBatchWriteRequests(Map<String, List<WriteRequest>> internal) {
        if (internal == null) {
            return null;
        }
        HashMap<String, List<software.amazon.awssdk.services.dynamodb.model.WriteRequest>> external = new HashMap<String, List<software.amazon.awssdk.services.dynamodb.model.WriteRequest>>(internal.size());
        for (Map.Entry<String, List<WriteRequest>> e : internal.entrySet()) {
            if (e.getValue() == null) {
                external.put(e.getKey(), null);
                continue;
            }
            ArrayList<software.amazon.awssdk.services.dynamodb.model.WriteRequest> writes = new ArrayList<software.amazon.awssdk.services.dynamodb.model.WriteRequest>(e.getValue().size());
            for (WriteRequest writeInternal : e.getValue()) {
                WriteRequest.Builder writeBuilder = software.amazon.awssdk.services.dynamodb.model.WriteRequest.builder();
                PutRequest putInternal = writeInternal.getPutRequest();
                DeleteRequest deleteInternal = writeInternal.getDeleteRequest();
                if (putInternal != null) {
                    software.amazon.awssdk.services.dynamodb.model.PutRequest putExternal = (software.amazon.awssdk.services.dynamodb.model.PutRequest)software.amazon.awssdk.services.dynamodb.model.PutRequest.builder().item(this.internalToExternalAttributes(putInternal.getItem())).build();
                    writeBuilder.putRequest(putExternal);
                }
                if (deleteInternal != null) {
                    software.amazon.awssdk.services.dynamodb.model.DeleteRequest deleteExternal = (software.amazon.awssdk.services.dynamodb.model.DeleteRequest)software.amazon.awssdk.services.dynamodb.model.DeleteRequest.builder().key(this.internalToExternalAttributes(deleteInternal.getKey())).build();
                    writeBuilder.deleteRequest(deleteExternal);
                }
                writes.add((software.amazon.awssdk.services.dynamodb.model.WriteRequest)writeBuilder.build());
            }
            external.put(e.getKey(), writes);
        }
        return external;
    }
}

