/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.cp;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.BillingModeSummary;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.OnDemandThroughput;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.DynamoDbApiFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;

public abstract class ControlPlaneFunction<I, O>
extends DynamoDbApiFunction<I, O> {
    public static final ProvisionedThroughput ZERO_PROVISIONED_THROUGHPUT = (ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(0L)).writeCapacityUnits(Long.valueOf(0L)).build();
    public static final OnDemandThroughput EMPTY_ONDEMAND_THROUGHPUT = (OnDemandThroughput)OnDemandThroughput.builder().maxReadRequestUnits(Long.valueOf(-1L)).maxWriteRequestUnits(Long.valueOf(-1L)).build();

    ControlPlaneFunction(LocalDBAccess dbAccess) {
        super(dbAccess);
    }

    int validateGSISchemas(List<GlobalSecondaryIndexDescription> gsiDescList, AttributeDefinition hashKeyDef, AttributeDefinition rangeKeyDef, List<AttributeDefinition> allAttributes, List<String> lsiNames, int numberOfProjectedAttrsInLSI, BillingMode billingMode) {
        HashSet<String> gsiNames = new HashSet<String>();
        HashSet<AttributeDefinition> gsiKeys = new HashSet<AttributeDefinition>();
        int totalProjectedAttrs = numberOfProjectedAttrsInLSI;
        for (GlobalSecondaryIndexDescription gsi : gsiDescList) {
            String gsiName = gsi.indexName();
            switch (IndexStatus.fromValue((String)gsi.indexStatusAsString())) {
                case CREATING: 
                case UPDATING: 
                case ACTIVE: {
                    AttributeDefinition gsiHashKeyDef;
                    if (BillingMode.PROVISIONED == billingMode) {
                        this.validateGSIProvisionedThroughput(LocalDBUtils.getPTfromPTDescription(gsi.provisionedThroughput()));
                    } else {
                        this.validateGSIOndemandThroughput(gsi);
                    }
                    this.validateTableName(gsiName);
                    ControlPlaneFunction.validateGSINames(gsiNames, gsiName);
                    if (lsiNames.contains(gsiName)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_NAME_LSI_GSI.getMessage());
                    }
                    if ((long)(totalProjectedAttrs += this.validateProjection(gsi.projection(), null)) > 100L) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_PROJECTED.getMessage());
                    }
                    gsiNames.add(gsiName);
                    List gsiSchema = gsi.keySchema();
                    this.validateKeySchema(gsiSchema);
                    KeySchemaElement gsiHashKey = (KeySchemaElement)gsiSchema.get(0);
                    KeySchemaElement gsiRangeKey = null;
                    if (gsiSchema.size() > 1) {
                        gsiRangeKey = (KeySchemaElement)gsiSchema.get(1);
                    }
                    if ((gsiHashKeyDef = LocalDBUtils.findAttributeDefinition(gsiHashKey, allAttributes)) == null) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_GSI_HASH_KEY.getMessage());
                    }
                    if (gsiRangeKey != null) {
                        AttributeDefinition gsiRangeKeyDef = LocalDBUtils.findAttributeDefinition(gsiRangeKey, allAttributes);
                        if (gsiRangeKeyDef == null) {
                            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_SPECIFIED_GSI_RANGE_KEY.getMessage());
                        }
                        if (!gsiRangeKeyDef.equals((Object)rangeKeyDef)) {
                            gsiKeys.add(gsiRangeKeyDef);
                        }
                    }
                    if (gsiHashKeyDef.equals((Object)hashKeyDef)) break;
                    gsiKeys.add(gsiHashKeyDef);
                    break;
                }
                case DELETING: {
                    this.validateTableName(gsiName);
                }
            }
        }
        return gsiKeys.size();
    }

    static void validateGSINames(Set<String> gsiNames, String gsiName) {
        if (gsiNames.contains(gsiName)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_NAME_GSI.getMessage());
        }
    }

    void validateGSIProvisionedThroughput(ProvisionedThroughput throughput) {
        if (throughput == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_GSI_NULL.getMessage());
        }
        Long readCapacity = throughput.readCapacityUnits();
        Long writeCapacity = throughput.writeCapacityUnits();
        if (readCapacity == null || writeCapacity == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES_GSI.getMessage());
        }
        ControlPlaneFunction.validateReadWriteCapacity(readCapacity, writeCapacity);
        if (throughput.readCapacityUnits() > 40000L || throughput.writeCapacityUnits() > 40000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_GSI.getMessage());
        }
    }

    static void validateReadWriteCapacity(Long readCapacity, Long writeCapacity) {
        if (readCapacity < 1L || writeCapacity < 1L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES_GSI.getMessage());
        }
    }

    void validateGSIOndemandThroughput(GlobalSecondaryIndexDescription gsi) {
        if (gsi.onDemandThroughput() != null) {
            Long readCapacity = gsi.onDemandThroughput().maxReadRequestUnits();
            Long writeCapacity = gsi.onDemandThroughput().maxWriteRequestUnits();
            if (readCapacity == null || writeCapacity == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES_GSI.getMessage());
            }
            if (readCapacity < 1L && readCapacity != -1L) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_MAX_READ_REQUEST_UNITS_GSI.getMessage(), gsi.indexName()));
            }
            if (writeCapacity < 1L && writeCapacity != -1L) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_MAX_WRITE_REQUEST_UNITS_GSI.getMessage(), gsi.indexName()));
            }
            if (gsi.onDemandThroughput().maxReadRequestUnits() > 40000L || gsi.onDemandThroughput().maxWriteRequestUnits() > 40000L) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_GSI.getMessage());
            }
        }
    }

    int validateProjection(Projection curProjection, List<String> projAttributes) {
        if (curProjection == null || curProjection.projectionType() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_INDEX_NO_PROJECTION.getMessage());
        }
        int projectedAttrs = 0;
        try {
            ProjectionType curProjectionType = ProjectionType.fromValue((String)curProjection.projectionTypeAsString());
            if (!ProjectionType.knownValues().contains(curProjection.projectionType())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PROJECTION_TYPE.getMessage());
            }
            if (curProjectionType == ProjectionType.INCLUDE) {
                List nonKeyAttrs = curProjection.nonKeyAttributes();
                if (nonKeyAttrs == null || nonKeyAttrs.size() == 0) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_PROJECTED_ATTRS.getMessage());
                }
                HashSet<String> nonKeyNamesSet = new HashSet<String>();
                for (String attrName : nonKeyAttrs) {
                    this.validateAttributeName(attrName);
                    if (nonKeyNamesSet.contains(attrName)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICAL_ATTRIBUTE_NAMES.getMessage());
                    }
                    if (projAttributes != null) {
                        projAttributes.add(attrName);
                    }
                    ++projectedAttrs;
                    nonKeyNamesSet.add(attrName);
                }
            } else if (!CollectionUtils.isNullOrEmpty((Collection)curProjection.nonKeyAttributes())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PROJECTED_ATTRS.getMessage());
            }
        }
        catch (IllegalArgumentException invalidException) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_PROJECTION_TYPE.getMessage());
        }
        return projectedAttrs;
    }

    void validateKeySchema(List<KeySchemaElement> keySchema) {
        if (keySchema.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_KEY_SCHEMA.getMessage());
        }
        int size = keySchema.size();
        if (size > 2) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.KEY_SCHEMA_TOO_BIG.getMessage());
        }
        int numHashKeys = 0;
        for (KeySchemaElement aKeySchema : keySchema) {
            if (aKeySchema == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_KEY_SCHEMA_ELEMENT.getMessage());
            }
            if (aKeySchema.keyType() == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.UNSPECIFIED_KEY_TYPE.getMessage());
            }
            if (aKeySchema.attributeName() == null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_NAME.getMessage());
            }
            if (!aKeySchema.keyTypeAsString().equals(KeyType.HASH.toString())) continue;
            ++numHashKeys;
        }
        if (numHashKeys == 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_HASH_KEY.getMessage());
        }
        if (numHashKeys == 2) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MANY_HASH_KEYS.getMessage());
        }
        if (size == 2 && keySchema.get(1).keyTypeAsString().equals(KeyType.HASH.toString())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCORRECT_KEY_SCHEMA_ORDER.getMessage());
        }
        if (size == 2 && keySchema.get(0).attributeName().equals(keySchema.get(1).attributeName())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICALLY_NAMED_KEYS.getMessage());
        }
    }

    void validateStreamSpecification(StreamSpecification newSpec, StreamSpecification currentSpec, boolean creatingTable) {
        if (newSpec == null) {
            return;
        }
        if (newSpec.streamEnabled() == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Stream StreamEnabled was null");
        }
        if (newSpec.streamEnabled().booleanValue()) {
            if (newSpec.streamViewType() == null || newSpec.streamViewTypeAsString().isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_STREAM_VIEW_TYPE.getMessage() + ": Stream ViewType must not be null or empty when enabling streams.");
            }
            try {
                StreamViewType.fromValue((String)newSpec.streamViewTypeAsString());
            }
            catch (IllegalArgumentException e) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_STREAM_VIEW_TYPE.getMessage() + ": " + newSpec.streamViewTypeAsString());
            }
            if (currentSpec != null && currentSpec.streamEnabled().booleanValue() && newSpec.streamEnabled().booleanValue()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_ENABLE_STREAM_REQUEST.getMessage());
            }
        } else {
            if (newSpec.streamViewTypeAsString() != null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_STREAM_VIEW_TYPE.getMessage() + ": Stream StreamEnabled was false but a StreamViewType was present.");
            }
            if (!creatingTable && (currentSpec == null || currentSpec != null && currentSpec.streamEnabled() != null && !currentSpec.streamEnabled().booleanValue())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_STREAM_REQUEST.getMessage());
            }
        }
    }

    TableDescription getTableDescriptionHelper(String tableName) {
        TableInfo tableInfo = this.validateTableExists(tableName);
        TableDescription tableDescription = null;
        tableDescription = tableInfo.getBillingMode().equals((Object)BillingMode.PAY_PER_REQUEST) ? ControlPlaneFunction.createTableDescriptionForPayPerRequest(tableName, tableInfo) : ControlPlaneFunction.createTableDescriptionForGenericThroughput(tableName, tableInfo);
        if (!((tableDescription = this.insertBillingModeSummaryIfNeeded(tableDescription, tableInfo)).streamSpecification() == null || tableDescription.streamSpecification().streamEnabled().booleanValue() && tableDescription.latestStreamArn() == null)) {
            AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR, "StreamARN should not be null if Streams is enabled");
        }
        if (tableDescription.streamSpecification() != null && !tableDescription.streamSpecification().streamEnabled().booleanValue()) {
            tableDescription = (TableDescription)tableDescription.toBuilder().streamSpecification((StreamSpecification)null).build();
        }
        return tableDescription;
    }

    static TableDescription createTableDescriptionForGenericThroughput(String tableName, TableInfo tableInfo) {
        return (TableDescription)TableDescription.builder().tableName(tableName).attributeDefinitions(tableInfo.getAttributeDefinitions()).keySchema(tableInfo.getKeySchema()).tableStatus(TableStatus.ACTIVE).creationDateTime(Instant.ofEpochMilli(tableInfo.getCreationDateTime())).provisionedThroughput(tableInfo.getThroughputDescription()).localSecondaryIndexes(tableInfo.getLSIDescriptions()).globalSecondaryIndexes(tableInfo.getGSIDescriptions()).streamSpecification(tableInfo.getStreamSpecification()).latestStreamArn(tableInfo.getLatestStreamId()).deletionProtectionEnabled(tableInfo.getDeleteProtectionEnabled()).latestStreamLabel(LocalDBUtils.extractStreamLabelFromArn(tableInfo.getLatestStreamId())).tableArn(LocalDBUtils.generateArn(tableName, null, null)).build();
    }

    static TableDescription createTableDescriptionForPayPerRequest(String tableName, TableInfo tableInfo) {
        if (tableInfo.getOndemandThroughput() != null && tableInfo.getOndemandThroughput().maxReadRequestUnits() > 0L && tableInfo.getOndemandThroughput().maxWriteRequestUnits() > 0L) {
            return (TableDescription)TableDescription.builder().tableName(tableName).attributeDefinitions(tableInfo.getAttributeDefinitions()).keySchema(tableInfo.getKeySchema()).tableStatus(TableStatus.ACTIVE).creationDateTime(Instant.ofEpochMilli(tableInfo.getCreationDateTime())).provisionedThroughput(tableInfo.getThroughputDescription()).onDemandThroughput(tableInfo.getOndemandThroughput()).localSecondaryIndexes(tableInfo.getLSIDescriptions()).globalSecondaryIndexes(tableInfo.getGSIDescriptions()).streamSpecification(tableInfo.getStreamSpecification()).latestStreamArn(tableInfo.getLatestStreamId()).deletionProtectionEnabled(tableInfo.getDeleteProtectionEnabled()).latestStreamLabel(LocalDBUtils.extractStreamLabelFromArn(tableInfo.getLatestStreamId())).tableArn(LocalDBUtils.generateArn(tableName, null, null)).build();
        }
        return ControlPlaneFunction.createTableDescriptionForGenericThroughput(tableName, tableInfo);
    }

    protected TableDescription insertBillingModeSummaryIfNeeded(TableDescription tableDescription, TableInfo tableInfo) {
        BillingMode billingMode = tableInfo.getBillingMode();
        if (BillingMode.PROVISIONED.equals((Object)billingMode) && tableInfo.getLastUpdateToPayPerRequestDateTime() > 0L || BillingMode.PAY_PER_REQUEST.equals((Object)billingMode)) {
            BillingModeSummary billingModeSummary = (BillingModeSummary)BillingModeSummary.builder().billingMode(billingMode).lastUpdateToPayPerRequestDateTime(Instant.ofEpochMilli(tableInfo.getLastUpdateToPayPerRequestDateTime())).build();
            return (TableDescription)tableDescription.toBuilder().billingModeSummary(billingModeSummary).build();
        }
        return tableDescription;
    }

    TableDescription fillDescriptionHelper(TableDescription description) {
        String indexName;
        String tableName = description.tableName();
        TableDescription.Builder descBuilder = description.toBuilder();
        long tableItemCount = this.dbAccess.getTableItemCount(tableName);
        descBuilder.itemCount(Long.valueOf(tableItemCount));
        descBuilder.tableSizeBytes(Long.valueOf(this.dbAccess.getTableByteSize(tableName)));
        if (description.hasLocalSecondaryIndexes()) {
            ArrayList<LocalSecondaryIndexDescription> updatedLSIs = new ArrayList<LocalSecondaryIndexDescription>();
            for (LocalSecondaryIndexDescription lsiDesc : description.localSecondaryIndexes()) {
                indexName = lsiDesc.indexName();
                long indexItemCount = this.dbAccess.getLSIItemCount(tableName, indexName);
                long indexSize = this.dbAccess.getLSIByteSize(tableName, indexName);
                LocalSecondaryIndexDescription updatedLSI = (LocalSecondaryIndexDescription)lsiDesc.toBuilder().itemCount(Long.valueOf(indexItemCount)).indexSizeBytes(Long.valueOf(indexSize)).build();
                updatedLSIs.add(updatedLSI);
            }
            descBuilder.localSecondaryIndexes(updatedLSIs);
        }
        if (description.hasGlobalSecondaryIndexes()) {
            ArrayList<GlobalSecondaryIndexDescription> updatedGSIs = new ArrayList<GlobalSecondaryIndexDescription>();
            for (GlobalSecondaryIndexDescription gsiDesc : description.globalSecondaryIndexes()) {
                if (this.isGSIInAStateToCountItems(gsiDesc)) {
                    indexName = gsiDesc.indexName();
                    GlobalSecondaryIndexDescription updatedGSI = (GlobalSecondaryIndexDescription)gsiDesc.toBuilder().itemCount(Long.valueOf(this.dbAccess.getGSIItemCount(tableName, indexName))).indexSizeBytes(Long.valueOf(this.dbAccess.getGSIByteSize(tableName, indexName))).build();
                    updatedGSIs.add(updatedGSI);
                    continue;
                }
                updatedGSIs.add(gsiDesc);
            }
            descBuilder.globalSecondaryIndexes(updatedGSIs);
        }
        return (TableDescription)descBuilder.build();
    }

    void validateProvisionedThroughputIncrease(ProvisionedThroughput throughputAfterUpdate, ProvisionedThroughput throughputBeforeUpdate) {
        if (throughputAfterUpdate == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_NULL.getMessage());
        }
        Long readCapacity = throughputAfterUpdate.readCapacityUnits();
        Long writeCapacity = throughputAfterUpdate.writeCapacityUnits();
        if (readCapacity == null || writeCapacity == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES.getMessage());
        }
        if (readCapacity < 1L || writeCapacity < 1L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES.getMessage());
        }
        if (throughputBeforeUpdate != null && throughputAfterUpdate.readCapacityUnits().equals(throughputBeforeUpdate.readCapacityUnits()) && throughputAfterUpdate.writeCapacityUnits().equals(throughputBeforeUpdate.writeCapacityUnits())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_THROUGHPUT.getMessage());
        }
    }

    void validateOndemandThroughputIncrease(OnDemandThroughput throughputAfterUpdate, OnDemandThroughput throughputBeforeUpdate) {
        if (throughputAfterUpdate == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_NULL.getMessage());
        }
        Long maxReadCapacity = throughputAfterUpdate.maxReadRequestUnits();
        Long maxWriteCapacity = throughputAfterUpdate.maxWriteRequestUnits();
        if (maxReadCapacity == null || maxWriteCapacity == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_THROUGHPUT_VALUES.getMessage());
        }
        if (maxReadCapacity < 1L && maxReadCapacity != -1L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, AmazonServiceExceptionType.INVALID_PARAMETER_MAX_READ_EXCEPTION.getMessage());
        }
        if (maxWriteCapacity < 1L && maxWriteCapacity != -1L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, AmazonServiceExceptionType.INVALID_PARAMETER_MAX_WRITE_EXCEPTION.getMessage());
        }
        if (throughputBeforeUpdate != null && throughputAfterUpdate.maxReadRequestUnits().equals(throughputBeforeUpdate.maxReadRequestUnits()) && throughputAfterUpdate.maxWriteRequestUnits().equals(throughputBeforeUpdate.maxWriteRequestUnits())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.SAME_THROUGHPUT.getMessage());
        }
    }

    void validateAttributeDefinitions(List<AttributeDefinition> attrDefs) {
        if (attrDefs.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_ATTRIBUTE_SCHEMA.getMessage());
        }
        HashSet<String> validatedAttrNames = new HashSet<String>();
        for (AttributeDefinition curAttr : attrDefs) {
            String curName = curAttr.attributeName();
            this.validateAttributeName(curName);
            if (validatedAttrNames.contains(curName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.IDENTICAL_ATTRIBUTE_NAMES.getMessage());
            }
            validatedAttrNames.add(curName);
            LocalDBUtils.getDataTypeOfAttributeDefinition(curAttr);
        }
        LocalDBUtils.getDataTypesOfAttributeDefinitions(attrDefs, false);
    }

    void validateProvisionedThroughputWithGSIs(String tableName, ProvisionedThroughput throughput, List<GlobalSecondaryIndexDescription> updatedGSIList) {
        if (throughput.readCapacityUnits() > 40000L || throughput.writeCapacityUnits() > 40000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_TABLE.getMessage());
        }
        long totalReadThroughput = 0L;
        long totalWriteThroughput = 0L;
        List<String> allTableNames = this.dbAccess.listTables(null, -1L).getTableNames();
        for (String table : allTableNames) {
            TableInfo tableInfo;
            if (table.equals(tableName) || !ControlPlaneFunction.isProvisioned(tableInfo = this.dbAccess.getTableInfo(table))) continue;
            ProvisionedThroughput existingThroughput = tableInfo.getThroughput();
            totalReadThroughput += existingThroughput.readCapacityUnits().longValue();
            totalWriteThroughput += existingThroughput.writeCapacityUnits().longValue();
            if (!tableInfo.hasGSIs()) continue;
            for (GlobalSecondaryIndexDescription gsi : tableInfo.getGSIDescriptions()) {
                totalReadThroughput += gsi.provisionedThroughput().readCapacityUnits().longValue();
                totalWriteThroughput += gsi.provisionedThroughput().writeCapacityUnits().longValue();
            }
        }
        totalReadThroughput += throughput.readCapacityUnits().longValue();
        totalWriteThroughput += throughput.writeCapacityUnits().longValue();
        if (updatedGSIList != null) {
            for (GlobalSecondaryIndexDescription gsi : updatedGSIList) {
                totalReadThroughput += gsi.provisionedThroughput().readCapacityUnits().longValue();
                totalWriteThroughput += gsi.provisionedThroughput().writeCapacityUnits().longValue();
            }
        }
        if (totalReadThroughput > 80000L || totalWriteThroughput > 80000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_ACCOUNT.getMessage());
        }
    }

    static boolean isProvisioned(TableInfo tableInfo) {
        return tableInfo.getBillingMode() == BillingMode.PROVISIONED;
    }

    void validateOndemandThroughputWithGSIs(String tableName, OnDemandThroughput throughput, List<GlobalSecondaryIndexDescription> updatedGSIList) {
        if (throughput.maxReadRequestUnits() > 40000L || throughput.maxWriteRequestUnits() > 40000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_TABLE.getMessage());
        }
        long totalReadThroughput = 0L;
        long totalWriteThroughput = 0L;
        List<String> allTableNames = this.dbAccess.listTables(null, -1L).getTableNames();
        for (String table : allTableNames) {
            if (table.equals(tableName)) continue;
            TableInfo tableInfo = this.dbAccess.getTableInfo(table);
            OnDemandThroughput existingThroughput = tableInfo.getOndemandThroughput();
            totalReadThroughput += this.getRequestUnits(existingThroughput.maxReadRequestUnits()).longValue();
            totalWriteThroughput += this.getRequestUnits(existingThroughput.maxWriteRequestUnits()).longValue();
            if (!tableInfo.hasGSIs()) continue;
            for (GlobalSecondaryIndexDescription gsi : tableInfo.getGSIDescriptions()) {
                totalReadThroughput += this.getReadRequestUnits(gsi.onDemandThroughput()).longValue();
                totalWriteThroughput += this.getWriteRequestUnits(gsi.onDemandThroughput()).longValue();
            }
        }
        totalReadThroughput += this.getRequestUnits(throughput.maxReadRequestUnits()).longValue();
        totalWriteThroughput += this.getRequestUnits(throughput.maxWriteRequestUnits()).longValue();
        if (updatedGSIList != null) {
            for (GlobalSecondaryIndexDescription gsi : updatedGSIList) {
                if (gsi.onDemandThroughput() == null) continue;
                totalReadThroughput += this.getRequestUnits(gsi.onDemandThroughput().maxReadRequestUnits()).longValue();
                totalWriteThroughput += this.getRequestUnits(gsi.onDemandThroughput().maxWriteRequestUnits()).longValue();
            }
        }
        if (totalReadThroughput > 80000L || totalWriteThroughput > 80000L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TOO_MUCH_THROUGHPUT_ACCOUNT.getMessage());
        }
    }

    private Long getRequestUnits(Long requestUnits) {
        return requestUnits == -1L ? 0L : requestUnits;
    }

    Long getReadRequestUnits(OnDemandThroughput requestUnits) {
        return requestUnits != null ? this.getRequestUnits(requestUnits.maxReadRequestUnits()) : 0L;
    }

    Long getWriteRequestUnits(OnDemandThroughput requestUnits) {
        return requestUnits != null ? this.getRequestUnits(requestUnits.maxWriteRequestUnits()) : 0L;
    }

    private boolean isGSIInAStateToCountItems(GlobalSecondaryIndexDescription description) {
        return IndexStatus.ACTIVE.toString().equals(description.indexStatusAsString()) || IndexStatus.CREATING.toString().equals(description.indexStatusAsString()) && Boolean.TRUE.equals(description.backfilling()) || IndexStatus.UPDATING.toString().equals(description.indexStatusAsString()) && Boolean.TRUE.equals(description.backfilling());
    }
}

