/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.cp;

import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.ListTablesResponseInfo;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.api.cp.ControlPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;

public class ListTablesFunction
extends ControlPlaneFunction<ListTablesRequest, ListTablesResponse> {
    public ListTablesFunction(LocalDBAccess dbAccess) {
        super(dbAccess);
    }

    @Override
    public ListTablesResponse apply(ListTablesRequest listTablesRequest) {
        long limit = this.validateLimitValueListTables(listTablesRequest.limit());
        String exclusiveStartTableName = listTablesRequest.exclusiveStartTableName();
        if (exclusiveStartTableName != null) {
            this.validateTableName(exclusiveStartTableName);
        }
        ListTablesResponseInfo initResults = this.dbAccess.listTables(exclusiveStartTableName, limit);
        return (ListTablesResponse)ListTablesResponse.builder().tableNames(initResults.getTableNames()).lastEvaluatedTableName(initResults.getLastEvaluatedTableName()).build();
    }

    private long validateLimitValueListTables(Integer limitInit) {
        long limit = this.validateLimitValue(limitInit);
        if (limit > 100L) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_LIMIT_TOO_BIG.getMessage());
        }
        return limit == -1L ? 100L : limit;
    }
}

