/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import ddb.partiql.shared.dbenv.PartiQLDbEnv;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.partiql.lang.ast.DataManipulation;
import org.partiql.lang.ast.DataManipulationOperation;
import org.partiql.lang.ast.ExprNode;
import org.partiql.lang.ast.NAry;
import org.partiql.lang.ast.NAryOp;
import org.partiql.lang.ast.Select;
import org.partiql.lang.ast.VariableReference;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.ParameterizedStatement;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PartiQLStatementFunction;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.processor.TransactionGetProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.processor.TransactionProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.processor.TransactionWriteProcessor;

public class ExecuteTransactionFunction
extends PartiQLStatementFunction<ExecuteTransactionRequest, ExecuteTransactionResponse> {
    public static final String TOO_LARGE_STATEMENT_LENGTH_ERR_MSG = "Member must have length less than or equal to 8192";
    public static final String PARTIQL_TRANSACT_EMPTY_STATEMENT = "ExecutePartiQLTransaction can not have empty statement.";
    public static final String PARTIQL_TRANSACT_REQUEST_MIXED_OPERATION = "ExecuteTransaction API does not support both read and write operations in the same request.";
    protected final Map<TransactionType, TransactionProcessor> transactionProcessors = this.populateTransactionProcessors();

    public ExecuteTransactionFunction(LocalDBAccess dbAccess, PartiQLDbEnv partiQLDbEnv, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DocumentFactory documentFactory) {
        super(dbAccess, partiQLDbEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory, TransactionsEnabledMode.TRANSACTIONS_ENABLED);
    }

    @Override
    public ExecuteTransactionResponse apply(ExecuteTransactionRequest input) {
        AbstractMap.SimpleEntry<TransactionType, List<ParsedPartiQLRequest<DataManipulation>>> parseResult = this.parse(input);
        TransactionType transactionType = parseResult.getKey();
        List<ParsedPartiQLRequest<DataManipulation>> parsedPartiQLRequests = parseResult.getValue();
        return this.transactionProcessors.get((Object)transactionType).execute(input.clientRequestToken(), parsedPartiQLRequests);
    }

    @VisibleForTesting
    public AbstractMap.SimpleEntry<TransactionType, List<ParsedPartiQLRequest<DataManipulation>>> parse(ExecuteTransactionRequest request) {
        ArrayList<ParsedPartiQLRequest> parsedPartiQLRequests = new ArrayList<ParsedPartiQLRequest>();
        if (request.transactStatements() == null || request.transactStatements().isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, PARTIQL_TRANSACT_EMPTY_STATEMENT);
        }
        if (request.transactStatements().size() > 100) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_TOO_MANY_REQUESTS.getMessage());
        }
        int index = 0;
        boolean isTransactGet = false;
        for (ParameterizedStatement transactionStatement : request.transactStatements()) {
            if (transactionStatement == null || Strings.isNullOrEmpty((String)transactionStatement.statement())) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, PARTIQL_TRANSACT_EMPTY_STATEMENT);
            }
            String statement = transactionStatement.statement();
            if (statement.getBytes().length > 8192) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, TOO_LARGE_STATEMENT_LENGTH_ERR_MSG);
            }
            ExprNode parsedExprNode = this.parseStatement(statement);
            Class<?> opClass = null;
            boolean isExistsFunction = false;
            if (parsedExprNode instanceof NAry) {
                List args = ((NAry)parsedExprNode).getArgs();
                if (((NAry)parsedExprNode).getOp() != NAryOp.CALL || args.size() != 2 || ((ExprNode)args.get(0)).getClass() != VariableReference.class || !"exists".equals(((VariableReference)args.get(0)).getId()) || ((ExprNode)args.get(1)).getClass() != Select.class) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Unsupported operation in transaction.");
                }
                isExistsFunction = true;
            } else {
                opClass = parsedExprNode.getClass();
                if (parsedExprNode instanceof DataManipulation) {
                    List ops = ((DataManipulation)parsedExprNode).getDmlOperations().getOps();
                    opClass = ((DataManipulationOperation)ops.get(0)).getClass();
                }
                this.verifySupportedOperation(opClass);
            }
            if (index == 0) {
                isTransactGet = !isExistsFunction && opClass.equals(Select.class);
            } else if (isTransactGet && (isExistsFunction || !opClass.equals(Select.class)) || !isTransactGet && !isExistsFunction && opClass.equals(Select.class)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, PARTIQL_TRANSACT_REQUEST_MIXED_OPERATION);
            }
            ++index;
            ParsedPartiQLRequest parsedRequest = ParsedPartiQLRequest.builder().exprNode(parsedExprNode).parameters(this.inputConverter.externalToInternalAttributeValues(transactionStatement.parameters())).returnValuesOnConditionCheckFailure(transactionStatement.returnValuesOnConditionCheckFailureAsString()).continuationToken(request.clientRequestToken()).build();
            parsedPartiQLRequests.add(parsedRequest);
        }
        TransactionType transactionType = isTransactGet ? TransactionType.TRANSACTION_GET : TransactionType.TRANSACTION_WRITE;
        return new AbstractMap.SimpleEntry<TransactionType, List<ParsedPartiQLRequest<DataManipulation>>>(transactionType, parsedPartiQLRequests);
    }

    private Map<TransactionType, TransactionProcessor> populateTransactionProcessors() {
        HashMap<TransactionType, TransactionProcessor> transactionProcessors = new HashMap<TransactionType, TransactionProcessor>();
        TransactionGetProcessor transactionGetProcessor = new TransactionGetProcessor(this.dbAccess, (LocalPartiQLDbEnv)this.localDBEnv, this, this.documentFactory);
        TransactionWriteProcessor transactionWriteProcessor = new TransactionWriteProcessor(this.dbAccess, (LocalPartiQLDbEnv)this.localDBEnv, this, this.documentFactory);
        transactionProcessors.put(TransactionType.TRANSACTION_GET, transactionGetProcessor);
        transactionProcessors.put(TransactionType.TRANSACTION_WRITE, transactionWriteProcessor);
        return transactionProcessors;
    }

    public static enum TransactionType {
        TRANSACTION_GET,
        TRANSACTION_WRITE;

    }
}

