/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.datamodel.ProjectionExpression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import com.amazonaws.services.dynamodbv2.rr.ProjectionExpressionWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.Capacity;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.LocalDBComparisonOperator;
import software.amazon.dynamodb.services.local.shared.access.DDBType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.QueryResponseInfo;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PaginatingFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.ConsumedCapacityUtils;
import software.amazon.dynamodb.services.local.shared.helpers.ExpressionUtils;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.Condition;
import software.amazon.dynamodb.services.local.shared.validate.RangeQueryExpressionsWrapper;

public class QueryFunction
extends PaginatingFunction<QueryRequest, QueryResponse> {
    public QueryFunction(LocalDBAccess dbAccess, DbEnv localDBEnv, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DocumentFactory documentFactory) {
        super(dbAccess, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory);
    }

    @Override
    public QueryResponse apply(QueryRequest queryRequest) {
        List<String> attributesProjectedInIndex;
        Projection indexProjection;
        Select select;
        int keySchemaSize;
        AttributeDefinition hashKeyDef;
        QueryResponse.Builder queryResponseBuilder = QueryResponse.builder();
        String unparsedTableName = queryRequest.tableName();
        String tableName = this.getTableNameFromPossibleArn(unparsedTableName);
        this.validateTableName(tableName);
        TableInfo tableInfo = this.validateTableExists(tableName);
        long limit = this.validateLimitValue(queryRequest.limit());
        Boolean asc = queryRequest.scanIndexForward();
        boolean ascending = asc == null || asc != false;
        boolean isGSIIndex = false;
        String indexName = queryRequest.indexName();
        if (indexName != null) {
            if (!tableInfo.hasIndex(indexName)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.SECONDARY_INDEXES_NOT_FOUND.getMessage(), indexName));
            }
            if (tableInfo.isGSIIndex(indexName)) {
                isGSIIndex = true;
            }
        }
        boolean isLSIIndex = indexName != null && !isGSIIndex;
        LocalDBValidatorUtils.validateExpressions(queryRequest, this.inputConverter);
        RangeQueryExpressionsWrapper rangeQueryExpressionsWrapper = this.inputConverter.externalToInternalExpressions(queryRequest.filterExpression(), queryRequest.projectionExpression(), queryRequest.keyConditionExpression(), queryRequest.expressionAttributeNames(), queryRequest.expressionAttributeValues());
        ExpressionWrapper filterExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getFilterExpressionWrapper();
        ProjectionExpressionWrapper projectionExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getProjectionExpressionWrapper();
        ExpressionWrapper keyConditionExpressionWrapper = rangeQueryExpressionsWrapper == null ? null : rangeQueryExpressionsWrapper.getKeyConditionExpressionWrapper();
        Expression filterExpression = filterExpressionWrapper == null ? null : filterExpressionWrapper.getExpression();
        ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, filterExpressionWrapper, this.awsExceptionFactory);
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, projectionExpressionWrapper, this.awsExceptionFactory);
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, keyConditionExpressionWrapper, this.awsExceptionFactory);
        Map<String, Condition> conditions = this.inputConverter.externalToInternalKeyConditions(queryRequest.keyConditions(), keyConditionExpressionWrapper);
        if (conditions == null || conditions.isEmpty()) {
            this.awsExceptionFactory.MISSING_KEY_CONDITIONS_AND_EXPRESSION.throwAsException();
        } else if (conditions.size() > 2) {
            this.awsExceptionFactory.INVALID_KEY_CONDITIONS_SIZE.throwAsException();
        }
        if (indexName != null && tableInfo.isGSIIndex(indexName)) {
            if (queryRequest.consistentRead() != null && queryRequest.consistentRead().booleanValue()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.CONSISTENT_GSI_QUERY.getMessage());
            }
            hashKeyDef = tableInfo.getGSIHashKey(indexName);
        } else {
            hashKeyDef = tableInfo.getHashKey();
        }
        AttributeDefinition rangeKeyDef = null;
        rangeKeyDef = indexName != null ? (isGSIIndex ? tableInfo.getGSIRangeKey(indexName) : tableInfo.getLSIRangeKey(indexName)) : tableInfo.getRangeKey();
        int n = keySchemaSize = rangeKeyDef == null ? 1 : 2;
        if (conditions.size() > keySchemaSize) {
            this.awsExceptionFactory.UNSUPPORTED_QUERY_KEY_CONDITION_SEQUENCE.throwAsException();
        }
        this.validateHashKeyCondition(hashKeyDef, conditions);
        this.validateKeyConditionForEmptyAttributeValue(hashKeyDef, conditions.get(hashKeyDef.attributeName()), indexName != null, indexName);
        if (rangeKeyDef != null) {
            this.validateRangeKeyCondition(rangeKeyDef, conditions);
            this.validateKeyConditionForEmptyAttributeValue(rangeKeyDef, conditions.get(rangeKeyDef.attributeName()), indexName != null, indexName);
        }
        Map exclusiveStartKey = null;
        if (queryRequest.exclusiveStartKey() != null && !queryRequest.exclusiveStartKey().isEmpty()) {
            exclusiveStartKey = (Map)this.inputConverter.externalToInternalAttributes(queryRequest.exclusiveStartKey());
        }
        List keyDefs = this.getKeyAttributes(tableInfo, indexName);
        this.validateExclusiveStartKeyQuery(exclusiveStartKey, tableInfo, keyDefs, conditions, ascending, tableInfo.getRangeKey(), indexName, isGSIIndex);
        Map<String, Condition> queryFilters = this.inputConverter.externalToInternalConditions(queryRequest.queryFilter());
        if (queryFilters == null) {
            queryFilters = new HashMap();
        }
        this.validateConditions(queryFilters, queryRequest.conditionalOperatorAsString());
        this.validateQueryFilterNotOnKey(queryFilters, this.localDBEnv, hashKeyDef, rangeKeyDef);
        this.validateQueryFilterExpressionNotOnKey(filterExpression, this.localDBEnv, hashKeyDef, rangeKeyDef);
        if (indexName != null) {
            this.validateQueryFilterAndFilterExprOnIndex(queryFilters, filterExpression, indexName, tableInfo);
        }
        if (!((select = this.validateSelect(queryRequest.selectAsString(), queryRequest.attributesToGet(), projectionExpression, indexName, tableInfo)) == Select.COUNT || StringUtils.isEmpty((CharSequence)queryRequest.projectionExpression()) && CollectionUtils.isNullOrEmpty((Collection)queryRequest.attributesToGet()))) {
            this.validateAttributesToGetAndProjExpr(queryRequest.attributesToGet(), projectionExpression, indexName, tableInfo);
        }
        QueryResponseInfo results = this.dbAccess.queryRecords(tableName, indexName, conditions, exclusiveStartKey, limit, ascending, null, null, false, isGSIIndex);
        int scannedItemCount = 0;
        List<Map<String, AttributeValue>> dbRecords = results.getReturnedRecords();
        Map<String, AttributeValue> lastEvaluatedItem = null;
        long totalSize = 0L;
        ArrayList<Map<String, AttributeValue>> chargeableDbRecords = new ArrayList<Map<String, AttributeValue>>();
        ArrayList<Map<String, AttributeValue>> dbRecordsAfterFiltering = new ArrayList<Map<String, AttributeValue>>();
        ConditionalOperator conditionalOperator = this.conditionalOperatorFrom(queryRequest.conditionalOperatorAsString());
        for (Map<String, AttributeValue> item : dbRecords) {
            ++scannedItemCount;
            lastEvaluatedItem = item;
            chargeableDbRecords.add(item);
            if (!this.doesItemMatchConditionalOperator(item, queryFilters, conditionalOperator) || !this.doesItemMatchFilterExpression((Map)item, filterExpression)) continue;
            dbRecordsAfterFiltering.add(item);
            if ((totalSize += LocalDBUtils.getItemSizeBytes(item)) < 0x100000L) continue;
            break;
        }
        if (isGSIIndex || isLSIIndex) {
            indexProjection = tableInfo.getProjection(indexName);
            attributesProjectedInIndex = this.determineAttributesToGetWhenSelectingAllProjectedAttributes(tableInfo, indexName, indexProjection.projectionTypeAsString(), indexProjection.nonKeyAttributes());
        } else {
            indexProjection = null;
            attributesProjectedInIndex = null;
        }
        List<Map<String, AttributeValue>> projectedChargeableDbRecords = LocalDBUtils.projectAttributesList(chargeableDbRecords, attributesProjectedInIndex);
        if (scannedItemCount == dbRecords.size()) {
            lastEvaluatedItem = results.getLastEvaluatedItem();
        }
        queryResponseBuilder.count(Integer.valueOf(dbRecordsAfterFiltering.size())).scannedCount(Integer.valueOf(scannedItemCount));
        if (select != Select.COUNT) {
            ArrayList<Map<String, AttributeValue>> filteredList = new ArrayList<Map<String, AttributeValue>>();
            List<String> attributesToGet = this.determineAttributesToGetForQuery(queryRequest, tableInfo, indexName, select);
            if (!StringUtils.isEmpty((CharSequence)queryRequest.projectionExpression())) {
                filteredList.addAll(LocalDBUtils.projectAttributesList(dbRecordsAfterFiltering, projectionExpression));
            } else {
                filteredList.addAll(LocalDBUtils.projectAttributesList(dbRecordsAfterFiltering, attributesToGet));
            }
            queryResponseBuilder.items(this.localDBOutputConverter.internalToExternalItemList(filteredList));
        }
        ArrayList<String> keyAttrs = new ArrayList<String>();
        for (AttributeDefinition attrDef : keyDefs) {
            keyAttrs.add(attrDef.attributeName());
        }
        Map<String, AttributeValue> lastKey = LocalDBUtils.projectAttributes(lastEvaluatedItem, keyAttrs);
        if (lastKey != null && this.exclusiveStartFitsConditions(lastKey, conditions, ascending, tableInfo.getRangeKey())) {
            queryResponseBuilder.lastEvaluatedKey(this.localDBOutputConverter.internalToExternalAttributes(lastKey));
        }
        if (indexName == null && !tableInfo.hasRangeKey()) {
            queryResponseBuilder.lastEvaluatedKey(null);
        }
        boolean stronglyConsistent = queryRequest.consistentRead() != null && queryRequest.consistentRead() != false;
        ReturnConsumedCapacity returnConsumedCapacity = ReturnConsumedCapacity.fromValue((String)(queryRequest.returnConsumedCapacity() != null ? queryRequest.returnConsumedCapacity().toString() : ReturnConsumedCapacity.NONE.toString()));
        ConsumedCapacity consumedCapacity = ConsumedCapacityUtils.computeConsumedCapacity(projectedChargeableDbRecords, isGSIIndex, !isGSIIndex && indexName != null, tableName, indexName, false, stronglyConsistent, this.transactionsMode, returnConsumedCapacity);
        if (!ConsumedCapacityUtils.doNotRequireConsumedCapacity(returnConsumedCapacity) && isLSIIndex && LSI_SELECTS_TO_READ_FROM_BASE_TABLE.contains(select) && !ProjectionType.ALL.equals((Object)ProjectionType.fromValue((String)indexProjection.projectionTypeAsString()))) {
            ConsumedCapacity baseTableConsumedCapacity = ConsumedCapacityUtils.computeConsumedCapacity(chargeableDbRecords, false, false, tableName, null, true, stronglyConsistent, TransactionsEnabledMode.TRANSACTIONS_DISABLED, returnConsumedCapacity);
            if (ReturnConsumedCapacity.INDEXES == returnConsumedCapacity) {
                Capacity.Builder newCapacity = Capacity.builder().capacityUnits(Double.valueOf(consumedCapacity.table().capacityUnits() + baseTableConsumedCapacity.capacityUnits()));
                consumedCapacity = (ConsumedCapacity)consumedCapacity.toBuilder().table((Capacity)newCapacity.build()).build();
            }
            consumedCapacity = (ConsumedCapacity)consumedCapacity.toBuilder().capacityUnits(Double.valueOf(consumedCapacity.capacityUnits() + baseTableConsumedCapacity.capacityUnits())).build();
        }
        return (QueryResponse)queryResponseBuilder.consumedCapacity(consumedCapacity).build();
    }

    void validateHashKeyCondition(AttributeDefinition hashKeyDef, Map<String, Condition> keyConditions) {
        AttributeValue expectedVal;
        List<AttributeValue> expectedVals;
        this.localDBEnv.dbAssert(keyConditions != null, "validateHashKeyCondition", "keyConditions should not be null", new Object[0]);
        this.localDBEnv.dbAssert(hashKeyDef != null, "validateHashKeyCondition", "table hash key schema should not be null", new Object[0]);
        Condition requestHashCondition = keyConditions.get(hashKeyDef.attributeName());
        if (requestHashCondition == null || requestHashCondition.getComparisonOperator() == null) {
            this.awsExceptionFactory.KEY_CONDITIONS_MISSING_KEY.throwAsException();
        }
        if ((expectedVals = requestHashCondition.getAttributeValueList()) == null || expectedVals.isEmpty()) {
            this.awsExceptionFactory.INVALID_HASH_KEY_VALUE.throwAsException();
        }
        if ((expectedVal = requestHashCondition.getAttributeValueList().get(0)) == null) {
            this.awsExceptionFactory.INVALID_HASH_KEY_VALUE.throwAsException();
        }
        LocalDBUtils.validateConsistentTypes(hashKeyDef, expectedVal, LocalDBClientExceptionMessage.INCONSISTENT_CONDITION_PARAMETER);
        if (!requestHashCondition.getComparisonOperator().equals(ComparisonOperator.EQ.toString())) {
            this.awsExceptionFactory.UNSUPPORTED_QUERY_KEY_CONDITION_SEQUENCE.throwAsException();
        }
        if (requestHashCondition.getAttributeValueList().size() > 1) {
            this.awsExceptionFactory.INVALID_FILTER_ARGUMENT_COUNT.throwAsException();
        }
        if (!DDBType.SortableScalarTypeSet.contains((Object)expectedVal.getType())) {
            this.awsExceptionFactory.INVALID_HASH_KEY_VALUE.throwAsException();
        }
    }

    private void validateKeyConditionForEmptyAttributeValue(AttributeDefinition keyDefinition, Condition keyCondition, boolean isIndex, String indexName) {
        block4: {
            block3: {
                if (keyCondition == null) {
                    return;
                }
                if (!"S".equals(keyDefinition.attributeTypeAsString())) break block3;
                for (AttributeValue attributeValue : keyCondition.getAttributeValueList()) {
                    this.validateKeyForEmptyStringValue(attributeValue, keyDefinition.attributeName(), isIndex, indexName, null);
                }
                break block4;
            }
            if (!"B".equals(keyDefinition.attributeTypeAsString())) break block4;
            for (AttributeValue attributeValue : keyCondition.getAttributeValueList()) {
                this.validateKeyForEmptyBinaryValue(attributeValue, keyDefinition.attributeName(), isIndex, indexName, null);
            }
        }
    }

    private void validateQueryFilterNotOnKey(Map<String, Condition> queryFilter, DbEnv dbEnv, AttributeDefinition hashKeyDef, AttributeDefinition rangeKeyDef) {
        if (queryFilter == null) {
            return;
        }
        if (queryFilter.containsKey(hashKeyDef.attributeName())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.QUERY_FILTER_CONTAINS_PRIMARY_KEY_ATTRIBUTES.getMessage(), hashKeyDef.attributeName()));
        }
        if (rangeKeyDef != null && queryFilter.containsKey(rangeKeyDef.attributeName())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.QUERY_FILTER_CONTAINS_PRIMARY_KEY_ATTRIBUTES.getMessage(), rangeKeyDef.attributeName()));
        }
    }

    private void validateRangeKeyCondition(AttributeDefinition rangeKeyDef, Map<String, Condition> keyConditions) {
        int expectedComparisonArguments;
        Condition requestRangeCondition = keyConditions.get(rangeKeyDef.attributeName());
        if (requestRangeCondition == null) {
            if (keyConditions.size() > 1) {
                this.awsExceptionFactory.KEY_CONDITIONS_MISSING_KEY.throwAsException();
            }
            return;
        }
        List<AttributeValue> expectedVals = requestRangeCondition.getAttributeValueList();
        if (expectedVals == null || expectedVals.isEmpty()) {
            this.awsExceptionFactory.INVALID_RANGE_KEY_VALUE.throwAsException();
        }
        for (AttributeValue expectedVal : requestRangeCondition.getAttributeValueList()) {
            if (LocalDBUtils.getAttributeValueSizeBytes(expectedVal) > 1024L) {
                this.awsExceptionFactory.INVALID_PARAMETER_VALUE.throwAsException("Aggregated size of all range keys has exceeded the size limit of 1024 bytes");
            }
            LocalDBUtils.validateConsistentTypes(rangeKeyDef, expectedVal, LocalDBClientExceptionMessage.INCONSISTENT_CONDITION_PARAMETER);
        }
        ComparisonOperator comparisonOperator = this.validateConditionType(requestRangeCondition);
        LocalDBComparisonOperator localOp = LocalDBComparisonOperator.fromValue(String.valueOf(comparisonOperator));
        if (!localOp.isValidForQuery()) {
            this.awsExceptionFactory.NON_INDEXABLE_CONDITION.throwAsException();
        }
        int n = expectedComparisonArguments = comparisonOperator == ComparisonOperator.BETWEEN ? 2 : 1;
        if (requestRangeCondition.getAttributeValueList().size() != expectedComparisonArguments) {
            this.awsExceptionFactory.INVALID_FILTER_ARGUMENT_COUNT.throwAsException();
        }
    }

    private void validateExclusiveStartKeyQuery(Map<String, AttributeValue> exclusiveStartKey, TableInfo tableInfo, List<AttributeDefinition> keyDefs, Map<String, Condition> queryConditions, boolean asc, AttributeDefinition rangeKey, String indexName, boolean isGsiIndex) {
        this.validateExclusiveStartKey((Map)exclusiveStartKey, (List)keyDefs);
        this.validateExclusiveStartKeyForEmptyAttributeValue((Map)exclusiveStartKey, tableInfo, indexName, isGsiIndex);
        if (exclusiveStartKey == null) {
            return;
        }
        if (!this.exclusiveStartFitsConditions(exclusiveStartKey, queryConditions, asc, rangeKey)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_START_KEY_RANGE.getMessage());
        }
    }

    private void validateQueryFilterExpressionNotOnKey(Expression filterExpression, DbEnv dbEnv, AttributeDefinition hashKeyDef, AttributeDefinition rangeKeyDef) {
        if (filterExpression == null) {
            return;
        }
        Set<String> topLevelAttributes = ExpressionUtils.getConditionExpressionTopLevelAttributes(filterExpression, dbEnv);
        if (topLevelAttributes.contains(hashKeyDef.attributeName())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.QUERY_FILTER_EXPRESSION_CONTAINS_PRIMARY_KEY_ATTRIBUTES.getMessage(), hashKeyDef.attributeName()));
        }
        if (rangeKeyDef != null && topLevelAttributes.contains(rangeKeyDef.attributeName())) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.QUERY_FILTER_EXPRESSION_CONTAINS_PRIMARY_KEY_ATTRIBUTES.getMessage(), rangeKeyDef.attributeName()));
        }
    }

    private boolean exclusiveStartFitsConditions(Map<String, AttributeValue> exclusiveStartKey, Map<String, Condition> queryConditions, boolean asc, AttributeDefinition rangeKey) {
        for (Map.Entry<String, AttributeValue> entry : exclusiveStartKey.entrySet()) {
            Condition keyCondition = queryConditions.get(entry.getKey());
            AttributeValue val = entry.getValue();
            if (keyCondition == null || !(rangeKey != null && entry.getKey().equals(rangeKey.attributeName()) ? !LocalDBComparisonOperator.fromValue(keyCondition.getComparisonOperator()).evaluateExclusive(keyCondition.getAttributeValueList(), val, asc) : !LocalDBComparisonOperator.fromValue(keyCondition.getComparisonOperator()).evaluate(keyCondition.getAttributeValueList(), val))) continue;
            return false;
        }
        return true;
    }

    private void validateQueryFilterAndFilterExprOnIndex(Map<String, Condition> queryFilter, Expression expression, String indexName, TableInfo tableInfo) {
        List<String> attributesThatAreNotProjectedOnIndex = this.getNonProjectedAttributeNames(queryFilter, expression, indexName, tableInfo);
        if (!attributesThatAreNotProjectedOnIndex.isEmpty()) {
            Collections.sort(attributesThatAreNotProjectedOnIndex);
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format(LocalDBClientExceptionMessage.INVALID_PARAMETER_VALUE.getMessage(), "Secondary index " + indexName + " does not project one or more filter attributes: " + String.valueOf(attributesThatAreNotProjectedOnIndex)));
        }
    }

    private List<String> getNonProjectedAttributeNames(Map<String, Condition> queryFilter, Expression expression, String indexName, TableInfo tableInfo) {
        Projection projection = tableInfo.getProjection(indexName);
        ProjectionType projectionType = ProjectionType.fromValue((String)projection.projectionTypeAsString());
        if (projectionType == ProjectionType.ALL) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (queryFilter != null) {
            list.addAll(queryFilter.keySet());
        }
        if (expression != null) {
            list.addAll(ExpressionUtils.getConditionExpressionTopLevelAttributes(expression, this.localDBEnv));
        }
        if (projection.nonKeyAttributes() != null) {
            list.removeAll(projection.nonKeyAttributes());
        }
        list.removeAll(this.getKeyAttributeNames(tableInfo));
        return list;
    }

    private List<String> determineAttributesToGetForQuery(QueryRequest queryRequest, TableInfo tableInfo, String indexName, Select select) {
        if (select == Select.SPECIFIC_ATTRIBUTES) {
            return queryRequest.attributesToGet();
        }
        if (select == Select.ALL_PROJECTED_ATTRIBUTES) {
            Projection indexProjection = tableInfo.getProjection(indexName);
            return this.determineAttributesToGetWhenSelectingAllProjectedAttributes(tableInfo, indexName, indexProjection.projectionTypeAsString(), indexProjection.nonKeyAttributes());
        }
        return null;
    }

    private ArrayList<String> getKeyAttributeNames(TableInfo tableInfo) {
        ArrayList<String> list = new ArrayList<String>();
        for (KeySchemaElement keySchemaElement : tableInfo.getKeySchema()) {
            list.add(keySchemaElement.attributeName());
        }
        return list;
    }
}

