/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.CancellationReason;
import software.amazon.awssdk.services.dynamodb.model.ConditionCheck;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItem;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.Update;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.exceptions.DynamoDBLocalServiceException;
import software.amazon.dynamodb.services.local.google.Lists;
import software.amazon.dynamodb.services.local.google.Sets;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.DeleteItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.GetItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PutItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.UpdateItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.WriteDataPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.ConsumedCapacityUtils;
import software.amazon.dynamodb.services.local.shared.helpers.MultiTableLock;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.mapper.DynamoDbObjectMapper;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.model.TableNameAndPrimaryKey;
import software.amazon.dynamodb.services.local.shared.validate.TransactionErrorMapper;
import software.amazon.dynamodb.services.local.shared.validate.UpdateItemExpressionsWrapper;

public class TransactWriteItemsFunction
extends WriteDataPlaneFunction<TransactWriteItemsRequest, TransactWriteItemsResponse> {
    private final PutItemFunction putItem;
    private final UpdateItemFunction updateItem;
    private final DeleteItemFunction deleteItem;
    private final GetItemFunction getItem;
    private final DynamoDbObjectMapper mapper = new DynamoDbObjectMapper();
    private final TransactionErrorMapper errorMapper;
    private final AWSExceptionFactory awsExceptionFactory;

    public TransactWriteItemsFunction(LocalDBAccess access, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DbEnv localDBEnv, DocumentFactory documentFactory) {
        super(access, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory, TransactionsEnabledMode.TRANSACTIONS_ENABLED);
        this.awsExceptionFactory = awsExceptionFactory;
        this.putItem = new PutItemFunction(access, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory, TransactionsEnabledMode.TRANSACTIONS_ENABLED);
        this.updateItem = new UpdateItemFunction(access, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory, TransactionsEnabledMode.TRANSACTIONS_ENABLED);
        this.deleteItem = new DeleteItemFunction(access, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory, TransactionsEnabledMode.TRANSACTIONS_ENABLED);
        this.getItem = new GetItemFunction(access, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, TransactionsEnabledMode.TRANSACTIONS_ENABLED);
        this.errorMapper = new TransactionErrorMapper(new AWSExceptionFactory());
    }

    @Override
    public TransactWriteItemsResponse apply(final TransactWriteItemsRequest input) {
        this.validateRequest(input);
        final String clientToken = input.clientRequestToken() == null ? UUID.randomUUID().toString() : input.clientRequestToken();
        TreeSet<String> tableNames = new TreeSet<String>();
        int i = 1;
        for (TransactWriteItem item : input.transactItems()) {
            String tableName = this.getTableName(item);
            if (tableName == null) {
                throw this.errorMapper.buildCoralValidationException("null", item, i, "tableName", "Member must not be null");
            }
            tableNames.add(tableName);
            ++i;
        }
        MultiTableLock tableLocker = new MultiTableLock(tableNames, this.dbAccess, MultiTableLock.LockMode.WRITE);
        final ReturnConsumedCapacity returnConsumedCapacity = this.convertReturnConsumedCapacity(input.returnConsumedCapacityAsString());
        final AtomicReference consumedCapacities = new AtomicReference();
        Runnable criticalSection = new Runnable(){

            @Override
            public void run() {
                List<ConsumedCapacity> result = TransactWriteItemsFunction.this.doWrite(input.transactItems(), clientToken, returnConsumedCapacity);
                consumedCapacities.set(result);
            }
        };
        tableLocker.wrapInTableLocks(criticalSection).run();
        return (TransactWriteItemsResponse)TransactWriteItemsResponse.builder().consumedCapacity(ConsumedCapacityUtils.mergeAllConsumedCapacities((List)consumedCapacities.get(), returnConsumedCapacity)).build();
    }

    private void validateRequest(TransactWriteItemsRequest request) {
        if (!request.hasTransactItems()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_WRITE_NULL_REQUESTS.getMessage());
        }
        if (request.transactItems().isEmpty()) {
            throw AWSExceptionFactory.buildCoralValidationException(request.transactItems().toString(), "transactItems", LocalDBClientExceptionMessage.TRANSACT_WRITE_EMPTY_REQUESTS.getMessage());
        }
        if (request.transactItems().size() > 100) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_TOO_MANY_REQUESTS.getMessage());
        }
        if (request.clientRequestToken() != null && request.clientRequestToken().length() > 36) {
            throw AWSExceptionFactory.buildCoralValidationException(request.clientRequestToken(), "clientRequestToken", LocalDBClientExceptionMessage.TRANSACT_IDEMPOTENT_TOKEN_TOO_LARGE.getMessage());
        }
        long transactionPayloadSizeBytes = 0L;
        for (TransactWriteItem writeItem : request.transactItems()) {
            this.validateTransactWriteItem(writeItem);
            if ((transactionPayloadSizeBytes += this.getItemPayloadSize(writeItem)) <= 0x400000L) continue;
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_REQUEST_PAYLOAD_TOO_LARGE.getMessage() + transactionPayloadSizeBytes);
        }
    }

    private void validateTransactWriteItem(TransactWriteItem writeItem) {
        int operations = 0;
        if (writeItem.conditionCheck() != null) {
            ++operations;
        }
        if (writeItem.delete() != null) {
            ++operations;
        }
        if (writeItem.put() != null) {
            ++operations;
        }
        if (writeItem.update() != null) {
            ++operations;
        }
        if (operations > 1) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_WRITE_MULTIPLE_OPERATIONS.getMessage());
        }
        if (operations == 0) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_WRITE_NO_OPERATIONS.getMessage());
        }
    }

    private String getTableName(TransactWriteItem item) {
        switch (OperationType.get(item)) {
            case CONDITION_CHECK: {
                return item.conditionCheck().tableName();
            }
            case DELETE: {
                return item.delete().tableName();
            }
            case PUT: {
                return item.put().tableName();
            }
            case UPDATE: {
                return item.update().tableName();
            }
        }
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR);
    }

    private long getItemPayloadSize(TransactWriteItem transactItem) {
        UpdateItemExpressionsWrapper expressionsWrapper = new UpdateItemExpressionsWrapper();
        Map item = null;
        long transactionPayloadSizeBytes = 0L;
        switch (OperationType.get(transactItem)) {
            case CONDITION_CHECK: {
                ConditionCheck conditionCheck = transactItem.conditionCheck();
                item = conditionCheck.key();
                expressionsWrapper.setConditionExpressionWrapper(this.inputConverter.externalToInternalConditionExpression(conditionCheck.conditionExpression(), conditionCheck.expressionAttributeNames(), conditionCheck.expressionAttributeValues()));
                break;
            }
            case DELETE: {
                Delete delete = transactItem.delete();
                item = delete.key();
                expressionsWrapper.setConditionExpressionWrapper(this.inputConverter.externalToInternalConditionExpression(delete.conditionExpression(), delete.expressionAttributeNames(), delete.expressionAttributeValues()));
                break;
            }
            case PUT: {
                Put put = transactItem.put();
                item = put.item();
                expressionsWrapper.setConditionExpressionWrapper(this.inputConverter.externalToInternalConditionExpression(put.conditionExpression(), put.expressionAttributeNames(), put.expressionAttributeValues()));
                break;
            }
            case UPDATE: {
                Update update = transactItem.update();
                item = update.key();
                expressionsWrapper = this.inputConverter.externalToInternalUpdateAndConditionExpressions(update.updateExpression(), update.conditionExpression(), update.expressionAttributeNames(), update.expressionAttributeValues());
                break;
            }
            default: {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR);
            }
        }
        if (item != null) {
            transactionPayloadSizeBytes += LocalDBUtils.getItemSizeBytes((Map)this.inputConverter.externalToInternalAttributes(item));
        }
        if (expressionsWrapper != null && expressionsWrapper.getUpdateExpressionWrapper() != null) {
            transactionPayloadSizeBytes += (long)expressionsWrapper.getUpdateExpressionWrapper().getCumulativeSize();
        }
        if (expressionsWrapper != null && expressionsWrapper.getConditionExpressionWrapper() != null) {
            transactionPayloadSizeBytes += (long)expressionsWrapper.getConditionExpressionWrapper().getCumulativeSize();
        }
        return transactionPayloadSizeBytes;
    }

    private List<Map<String, AttributeValue>> collectAllExistingItems(List<TransactWriteItem> writeItems) {
        List<Map<String, AttributeValue>> result = Lists.newArrayList(new Map[0]);
        boolean canceled = false;
        List<CancellationReason> cancellationReasons = Lists.newArrayList(new CancellationReason[0]);
        for (TransactWriteItem writeItem : writeItems) {
            try {
                result.add(this.getExistingItem(writeItem));
                cancellationReasons.add(this.errorMapper.getEmptyCancellationReason());
            }
            catch (DynamoDBLocalServiceException e) {
                canceled = true;
                cancellationReasons.add(this.errorMapper.mapToCancellationReasonWhenGettingExistingItem(e));
            }
        }
        if (canceled) {
            throw AWSExceptionFactory.buildTransactionCanceledException(cancellationReasons);
        }
        return result;
    }

    private Map<String, AttributeValue> getExistingItem(TransactWriteItem writeItem) {
        String tableName = this.getTableName(writeItem);
        TableInfo tableInfo = this.validateTableExists(tableName);
        Map<String, AttributeValue> primaryKey = this.key(writeItem, tableInfo);
        Map<String, AttributeValue> existingItem = this.dbAccess.getRecord(tableName, primaryKey);
        return existingItem;
    }

    private Map<String, AttributeValue> key(TransactWriteItem writeItem, TableInfo tableInfo) {
        switch (OperationType.get(writeItem)) {
            case CONDITION_CHECK: {
                return (Map)this.inputConverter.externalToInternalAttributes(writeItem.conditionCheck().key());
            }
            case DELETE: {
                return (Map)this.inputConverter.externalToInternalAttributes(writeItem.delete().key());
            }
            case PUT: {
                Map item = (Map)this.inputConverter.externalToInternalAttributes(writeItem.put().item());
                return this.validatePutItem(item, tableInfo);
            }
            case UPDATE: {
                return (Map)this.inputConverter.externalToInternalAttributes(writeItem.update().key());
            }
        }
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INTERNAL_SERVER_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConsumedCapacity> doWrite(List<TransactWriteItem> writeItems, String clientToken, ReturnConsumedCapacity returnConsumedCapacity) {
        List<ConsumedCapacity> result = Lists.newArrayListWithExpectedSize(writeItems.size());
        byte[] transactionSignature = this.calculateTransactionSignature(writeItems);
        byte[] previousSignature = this.dbAccess.beginTransaction(clientToken);
        if (previousSignature != null) {
            try {
                if (!Arrays.equals(transactionSignature, previousSignature)) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.IDEMPOTENT_PARAMETER_MISMATCH_EXCEPTION);
                }
                List<Map<String, AttributeValue>> existingItems = this.collectAllExistingItems(writeItems);
                for (int i = 0; i < writeItems.size(); ++i) {
                    ConsumedCapacity consumedCapacity = ConsumedCapacityUtils.computeConsumedCapacity(Collections.singletonList(existingItems.get(i)), false, false, this.getTableName(writeItems.get(i)), null, true, true, this.transactionsMode, returnConsumedCapacity);
                    ConsumedCapacityUtils.copyToReadConsumedCapacity(consumedCapacity);
                    if (consumedCapacity == null) continue;
                    result.add(consumedCapacity);
                }
                List<ConsumedCapacity> i = result;
                return i;
            }
            finally {
                this.dbAccess.rollbackTransaction();
            }
        }
        try {
            boolean canceled = false;
            Set<TableNameAndPrimaryKey> keysInvolved = Sets.newHashSet(new TableNameAndPrimaryKey[0]);
            List<CancellationReason> cancellationReasons = Lists.newArrayList(new CancellationReason[0]);
            for (int i = 0; i < writeItems.size(); ++i) {
                TransactWriteItem item = writeItems.get(i);
                ConsumedCapacity consumedCapacity = null;
                try {
                    TableInfo tableInfo;
                    Map<String, AttributeValue> primaryKey;
                    String tableName;
                    TableNameAndPrimaryKey tableAndKey;
                    if (item.put() != null) {
                        request = this.putToPutItemRequest(item.put(), returnConsumedCapacity);
                        try {
                            consumedCapacity = this.putItem.apply(request).consumedCapacity();
                        }
                        catch (DynamoDBLocalServiceException e) {
                            throw this.errorMapper.mapToCorrectExceptionForPutRequest(e, item, i);
                        }
                    } else if (item.update() != null) {
                        request = this.updateToUpdateItemRequest(item.update(), returnConsumedCapacity);
                        try {
                            consumedCapacity = this.updateItem.apply((UpdateItemRequest)request).consumedCapacity();
                        }
                        catch (DynamoDBLocalServiceException e) {
                            throw this.errorMapper.mapToCorrectExceptionForUpdateRequest(e, item, i);
                        }
                    } else if (item.delete() != null) {
                        request = this.deleteToDeleteItemRequest(item.delete(), returnConsumedCapacity);
                        try {
                            consumedCapacity = this.deleteItem.apply((DeleteItemRequest)request).consumedCapacity();
                        }
                        catch (DynamoDBLocalServiceException e) {
                            throw this.errorMapper.mapToCorrectExceptionForKeyedRequest(e, item, i);
                        }
                    } else if (item.conditionCheck() != null) {
                        consumedCapacity = this.handleConditionCheckRequest(item, returnConsumedCapacity, i);
                    } else {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.UNKNOWN_OPERATION_EXCEPTION);
                    }
                    ConsumedCapacityUtils.doubleAndCopyToWriteConsumedCapacity(consumedCapacity);
                    if (consumedCapacity != null) {
                        result.add(consumedCapacity);
                    }
                    if (!keysInvolved.add(tableAndKey = new TableNameAndPrimaryKey(tableName = this.getTableName(item), primaryKey = this.key(item, tableInfo = this.validateTableExists(tableName))))) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_DUPLICATE_KEY.getMessage());
                    }
                    cancellationReasons.add(this.errorMapper.getEmptyCancellationReason());
                    continue;
                }
                catch (DynamoDBLocalServiceException e) {
                    canceled = true;
                    CancellationReason ll = this.errorMapper.mapToCancellationReasonWhenHandlingTransactionOperation(e, item, i);
                    cancellationReasons.add(ll);
                }
            }
            if (canceled) {
                long transactionResponsePayloadSizeBytes = 0L;
                for (int i = 0; i < cancellationReasons.size(); ++i) {
                    TransactWriteItem writeItem;
                    ReturnValuesOnConditionCheckFailure returnValues;
                    CancellationReason reason = cancellationReasons.get(i);
                    if (Objects.equals(reason.code(), "ConditionalCheckFailed") && (returnValues = this.getReturnValuesOnConditionCheckFailure(writeItem = writeItems.get(i))) == ReturnValuesOnConditionCheckFailure.ALL_OLD && !Objects.equals(reason.code(), "None")) {
                        Map<String, AttributeValue> existingItem = this.getExistingItem(writeItem);
                        cancellationReasons.set(i, (CancellationReason)reason.toBuilder().item(this.localDBOutputConverter.internalToExternalAttributes(existingItem)).build());
                        transactionResponsePayloadSizeBytes += 4L;
                        transactionResponsePayloadSizeBytes += LocalDBUtils.getItemSizeBytes(existingItem);
                    }
                    if (transactionResponsePayloadSizeBytes <= 0x400000L) continue;
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.TRANSACT_RESPONSE_PAYLOAD_TOO_LARGE.getMessage() + transactionResponsePayloadSizeBytes);
                }
                throw AWSExceptionFactory.buildTransactionCanceledException(cancellationReasons);
            }
            this.dbAccess.commitTransaction(clientToken, transactionSignature);
            return result;
        }
        catch (RuntimeException e) {
            this.dbAccess.rollbackTransaction();
            throw e;
        }
    }

    public byte[] calculateTransactionSignature(List<TransactWriteItem> writeItems) {
        try {
            List hashes = writeItems.stream().map(TransactWriteItem::hashCode).collect(Collectors.toList());
            byte[] value = this.mapper.writeValueAsBytes(hashes);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return md.digest(value);
        }
        catch (JsonProcessingException | NoSuchAlgorithmException e) {
            throw AWSExceptionFactory.buildInternalServerException(e.getMessage());
        }
    }

    private PutItemRequest putToPutItemRequest(Put put, ReturnConsumedCapacity returnConsumedCapacity) {
        return (PutItemRequest)PutItemRequest.builder().tableName(put.tableName()).conditionExpression(put.conditionExpression()).expressionAttributeNames(put.expressionAttributeNames()).expressionAttributeValues(put.expressionAttributeValues()).item(put.item()).returnValues(this.returnValue(put.returnValuesOnConditionCheckFailureAsString())).returnConsumedCapacity(returnConsumedCapacity).build();
    }

    private UpdateItemRequest updateToUpdateItemRequest(Update update, ReturnConsumedCapacity returnConsumedCapacity) {
        return (UpdateItemRequest)UpdateItemRequest.builder().conditionExpression(update.conditionExpression()).expressionAttributeNames(update.expressionAttributeNames()).expressionAttributeValues(update.expressionAttributeValues()).key(update.key()).returnValues(this.returnValue(update.returnValuesOnConditionCheckFailureAsString())).tableName(update.tableName()).updateExpression(update.updateExpression()).returnConsumedCapacity(returnConsumedCapacity).build();
    }

    private DeleteItemRequest deleteToDeleteItemRequest(Delete delete, ReturnConsumedCapacity returnConsumedCapacity) {
        return (DeleteItemRequest)DeleteItemRequest.builder().tableName(delete.tableName()).key(delete.key()).conditionExpression(delete.conditionExpression()).expressionAttributeNames(delete.expressionAttributeNames()).expressionAttributeValues(delete.expressionAttributeValues()).returnValues(this.returnValue(delete.returnValuesOnConditionCheckFailureAsString())).returnConsumedCapacity(returnConsumedCapacity).build();
    }

    private GetItemRequest conditionCheckToGetItemRequest(ConditionCheck conditionCheck, ReturnConsumedCapacity returnConsumedCapacity) {
        return (GetItemRequest)GetItemRequest.builder().tableName(conditionCheck.tableName()).key(conditionCheck.key()).consistentRead(Boolean.valueOf(true)).returnConsumedCapacity(returnConsumedCapacity).build();
    }

    private ReturnValuesOnConditionCheckFailure getReturnValuesOnConditionCheckFailure(TransactWriteItem writeItem) {
        String value = null;
        switch (OperationType.get(writeItem)) {
            case CONDITION_CHECK: {
                value = writeItem.conditionCheck().returnValuesOnConditionCheckFailureAsString();
                break;
            }
            case DELETE: {
                value = writeItem.delete().returnValuesOnConditionCheckFailureAsString();
                break;
            }
            case PUT: {
                value = writeItem.put().returnValuesOnConditionCheckFailureAsString();
                break;
            }
            case UPDATE: {
                value = writeItem.update().returnValuesOnConditionCheckFailureAsString();
            }
        }
        return this.getReturnValuesOnConditionCheckFailure(value);
    }

    private ReturnValue returnValue(String input) {
        if (input == null) {
            input = "NONE";
        }
        if (Objects.requireNonNull(ReturnValuesOnConditionCheckFailure.fromValue((String)input)) == ReturnValuesOnConditionCheckFailure.ALL_OLD) {
            return ReturnValue.ALL_OLD;
        }
        return ReturnValue.NONE;
    }

    private ConsumedCapacity handleConditionCheckRequest(TransactWriteItem item, ReturnConsumedCapacity returnConsumedCapacity, int position) {
        ConditionCheck conditionCheck = item.conditionCheck();
        GetItemRequest request = this.conditionCheckToGetItemRequest(conditionCheck, returnConsumedCapacity);
        GetItemResponse getItemResponse = null;
        try {
            getItemResponse = this.getItem.apply(request);
        }
        catch (DynamoDBLocalServiceException e) {
            throw this.errorMapper.mapToCorrectExceptionForKeyedRequest(e, item, position);
        }
        ExpressionWrapper expressionWrapper = this.inputConverter.externalToInternalConditionExpression(conditionCheck.conditionExpression(), conditionCheck.expressionAttributeNames(), conditionCheck.expressionAttributeValues());
        if (expressionWrapper == null) {
            int errorPosition = position + 1;
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Value null at 'transactItems." + errorPosition + ".member.conditionCheck.conditionExpression' failed to satisfy constraint: Member must not be null");
        }
        Expression expression = expressionWrapper.getExpression();
        Map existingItem = !getItemResponse.hasItem() || getItemResponse.item().isEmpty() ? Collections.emptyMap() : (Map)this.inputConverter.externalToInternalAttributes(getItemResponse.item());
        if (!LocalDBUtils.doesItemMatchCondition(existingItem, expression, this.localDBEnv, this.documentFactory)) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION);
        }
        return getItemResponse.consumedCapacity();
    }

    public static enum OperationType {
        CONDITION_CHECK("conditionCheck"),
        DELETE("delete"),
        PUT("put"),
        UPDATE("update");

        private final String apiName;

        private OperationType(String apiName) {
            this.apiName = apiName;
        }

        public static OperationType get(TransactWriteItem item) {
            if (item.conditionCheck() != null) {
                return CONDITION_CHECK;
            }
            if (item.delete() != null) {
                return DELETE;
            }
            if (item.put() != null) {
                return PUT;
            }
            if (item.update() != null) {
                return UPDATE;
            }
            throw new IllegalArgumentException("No operation type.");
        }

        public String getApiName() {
            return this.apiName;
        }
    }
}

