/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.client;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListExportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListExportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ListContributorInsightsIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ListExportsIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ListTablesIterable;
import software.amazon.awssdk.services.dynamodb.paginators.QueryIterable;
import software.amazon.awssdk.services.dynamodb.paginators.ScanIterable;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.exceptions.DynamoDBLocalServiceException;
import software.amazon.dynamodb.services.local.shared.access.ListTablesResponseInfo;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.api.cp.CreateTableFunction;
import software.amazon.dynamodb.services.local.shared.access.api.cp.DeleteTableFunction;
import software.amazon.dynamodb.services.local.shared.access.api.cp.DescribeLimitsFunction;
import software.amazon.dynamodb.services.local.shared.access.api.cp.DescribeTableFunction;
import software.amazon.dynamodb.services.local.shared.access.api.cp.ListTablesFunction;
import software.amazon.dynamodb.services.local.shared.access.api.cp.UpdateTableFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.BatchExecuteStatementFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.BatchGetItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.BatchWriteItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.DeleteItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.ExecuteStatementFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.ExecuteTransactionFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.GetItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PutItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.QueryFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.ScanFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.TransactGetItemsFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.TransactWriteItemsFunction;
import software.amazon.dynamodb.services.local.shared.access.api.dp.UpdateItemFunction;
import software.amazon.dynamodb.services.local.shared.access.api.ttl.DescribeTimeToLiveFunction;
import software.amazon.dynamodb.services.local.shared.access.api.ttl.UpdateTimeToLiveFunction;
import software.amazon.dynamodb.services.local.shared.access.client.PaginatorUtils;
import software.amazon.dynamodb.services.local.shared.dataaccess.LocalDocumentFactory;
import software.amazon.dynamodb.services.local.shared.env.LocalDBEnv;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.jobs.CreateGSIJobScheduler;
import software.amazon.dynamodb.services.local.shared.jobs.DeleteGSIJobScheduler;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;
import software.amazon.dynamodb.services.local.shared.jobs.TimeToLiveDeletionJobScheduler;

public class LocalDynamoDbClient
implements DynamoDbClient {
    private final String SERVICE_NAME = "dynamodb";
    private final LocalDBInputConverter inputConverter;
    private final DbEnv localDBEnv;
    private final DocumentFactory documentFactory;
    private final LocalDBOutputConverter localDBOutputConverter;
    private final AWSExceptionFactory awsExceptionFactory;
    public final LocalPartiQLDbEnv localPartiQLDbEnv;
    public final LocalDBAccess dbAccess;
    private final JobsRegister jobs;

    public LocalDynamoDbClient(LocalDBAccess dbAccess, JobsRegister jobs) {
        this.dbAccess = dbAccess;
        this.localDBEnv = new LocalDBEnv();
        this.documentFactory = new LocalDocumentFactory();
        this.awsExceptionFactory = new AWSExceptionFactory();
        this.inputConverter = new LocalDBInputConverter(this.localDBEnv, this.awsExceptionFactory, this.documentFactory, 65536);
        this.localDBOutputConverter = new LocalDBOutputConverter();
        this.localPartiQLDbEnv = new LocalPartiQLDbEnv();
        this.jobs = jobs;
        this.jobs.schedule(new CreateGSIJobScheduler(dbAccess, this.jobs));
        this.jobs.schedule(new DeleteGSIJobScheduler(dbAccess, this.jobs));
        this.jobs.schedule(new TimeToLiveDeletionJobScheduler(dbAccess, this, this.inputConverter, this.jobs));
    }

    public String serviceName() {
        return "dynamodb";
    }

    public void close() {
    }

    public BatchExecuteStatementResponse batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest) throws AwsServiceException, SdkClientException {
        return new BatchExecuteStatementFunction(this.dbAccess, this.localPartiQLDbEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory, TransactionsEnabledMode.TRANSACTIONS_DISABLED).apply(batchExecuteStatementRequest);
    }

    public BatchGetItemResponse batchGetItem(BatchGetItemRequest batchGetItemRequest) throws AwsServiceException, SdkClientException {
        return new BatchGetItemFunction(this.dbAccess, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.localDBEnv).apply(batchGetItemRequest);
    }

    public BatchGetItemIterable batchGetItemPaginator(BatchGetItemRequest batchGetItemRequest) throws AwsServiceException, SdkClientException {
        return new BatchGetItemIterable((DynamoDbClient)this, PaginatorUtils.applyPaginatorUserAgent(batchGetItemRequest));
    }

    public BatchWriteItemResponse batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) throws AwsServiceException, SdkClientException {
        return new BatchWriteItemFunction(this.dbAccess, this.localDBEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory).apply(batchWriteItemRequest);
    }

    public CreateBackupResponse createBackup(CreateBackupRequest createBackupRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.BACKUP_OPERATION_NOT_SUPPORTED);
    }

    public CreateGlobalTableResponse createGlobalTable(CreateGlobalTableRequest createGlobalTableRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.GLOBAL_TABLE_OPERATION_NOT_SUPPORTED);
    }

    public CreateTableResponse createTable(CreateTableRequest createTableRequest) throws AwsServiceException, SdkClientException {
        return new CreateTableFunction(this.dbAccess).apply(createTableRequest);
    }

    public DeleteBackupResponse deleteBackup(DeleteBackupRequest deleteBackupRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.BACKUP_OPERATION_NOT_SUPPORTED);
    }

    public DeleteItemResponse deleteItem(DeleteItemRequest deleteItemRequest) throws AwsServiceException, SdkClientException {
        return new DeleteItemFunction(this.dbAccess, this.localDBEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory, TransactionsEnabledMode.TRANSACTIONS_DISABLED).apply(deleteItemRequest);
    }

    public DeleteTableResponse deleteTable(DeleteTableRequest deleteTableRequest) throws AwsServiceException, SdkClientException {
        return new DeleteTableFunction(this.dbAccess).apply(deleteTableRequest);
    }

    public DescribeBackupResponse describeBackup(DescribeBackupRequest describeBackupRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.BACKUP_OPERATION_NOT_SUPPORTED);
    }

    public DescribeContinuousBackupsResponse describeContinuousBackups(DescribeContinuousBackupsRequest describeContinuousBackupsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.CONTINUOUS_BACKUP_OPERATION_NOT_SUPPORTED);
    }

    public DescribeContributorInsightsResponse describeContributorInsights(DescribeContributorInsightsRequest describeContributorInsightsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.CONTRIBUTOR_INSIGHTS_OPERATION_NOT_SUPPORTED);
    }

    public DescribeEndpointsResponse describeEndpoints() throws AwsServiceException, SdkClientException {
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION, LocalDBClientExceptionMessage.ENDPOINT_OPERATION_NOT_SUPPORTED.getMessage());
    }

    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws AwsServiceException, SdkClientException {
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.INVALID_ACTION, LocalDBClientExceptionMessage.ENDPOINT_OPERATION_NOT_SUPPORTED.getMessage());
    }

    public DescribeExportResponse describeExport(DescribeExportRequest describeExportRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.EXPORT_OPERATION_NOT_SUPPORTED);
    }

    public DescribeGlobalTableResponse describeGlobalTable(DescribeGlobalTableRequest describeGlobalTableRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.GLOBAL_TABLE_OPERATION_NOT_SUPPORTED);
    }

    public DescribeGlobalTableSettingsResponse describeGlobalTableSettings(DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.GLOBAL_TABLE_OPERATION_NOT_SUPPORTED);
    }

    public DescribeKinesisStreamingDestinationResponse describeKinesisStreamingDestination(DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.KINESIS_STREAMING_OPERATION_NOT_SUPPORTED);
    }

    public DescribeLimitsResponse describeLimits(DescribeLimitsRequest describeLimitsRequest) throws AwsServiceException, SdkClientException {
        return new DescribeLimitsFunction().apply();
    }

    public DescribeTableResponse describeTable(DescribeTableRequest describeTableRequest) throws AwsServiceException, SdkClientException {
        return new DescribeTableFunction(this.dbAccess).apply(describeTableRequest);
    }

    public DescribeTableReplicaAutoScalingResponse describeTableReplicaAutoScaling(DescribeTableReplicaAutoScalingRequest describeTableReplicaAutoScalingRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.TABLE_REPLICA_AUTO_SCALING_OPERATION_NOT_SUPPORTED);
    }

    public DescribeTimeToLiveResponse describeTimeToLive(DescribeTimeToLiveRequest describeTimeToLiveRequest) throws AwsServiceException, SdkClientException {
        return new DescribeTimeToLiveFunction(this.dbAccess).apply(describeTimeToLiveRequest);
    }

    public DisableKinesisStreamingDestinationResponse disableKinesisStreamingDestination(DisableKinesisStreamingDestinationRequest disableKinesisStreamingDestinationRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.KINESIS_STREAMING_OPERATION_NOT_SUPPORTED);
    }

    public EnableKinesisStreamingDestinationResponse enableKinesisStreamingDestination(EnableKinesisStreamingDestinationRequest enableKinesisStreamingDestinationRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.KINESIS_STREAMING_OPERATION_NOT_SUPPORTED);
    }

    public ExecuteStatementResponse executeStatement(ExecuteStatementRequest executeStatementRequest) throws AwsServiceException, SdkClientException {
        return new ExecuteStatementFunction(this.dbAccess, this.localPartiQLDbEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory, TransactionsEnabledMode.TRANSACTIONS_DISABLED).apply(executeStatementRequest);
    }

    public ExecuteTransactionResponse executeTransaction(ExecuteTransactionRequest executeTransactionRequest) throws AwsServiceException, SdkClientException {
        return new ExecuteTransactionFunction(this.dbAccess, this.localPartiQLDbEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory).apply(executeTransactionRequest);
    }

    public ExportTableToPointInTimeResponse exportTableToPointInTime(ExportTableToPointInTimeRequest exportTableToPointInTimeRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.EXPORT_OPERATION_NOT_SUPPORTED);
    }

    public GetItemResponse getItem(GetItemRequest getItemRequest) throws AwsServiceException, SdkClientException {
        return new GetItemFunction(this.dbAccess, this.localDBEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, TransactionsEnabledMode.TRANSACTIONS_DISABLED).apply(getItemRequest);
    }

    public ListBackupsResponse listBackups() throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.BACKUP_OPERATION_NOT_SUPPORTED);
    }

    public ListBackupsResponse listBackups(ListBackupsRequest listBackupsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.BACKUP_OPERATION_NOT_SUPPORTED);
    }

    public ListContributorInsightsResponse listContributorInsights(ListContributorInsightsRequest listContributorInsightsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.CONTRIBUTOR_INSIGHTS_OPERATION_NOT_SUPPORTED);
    }

    public ListContributorInsightsIterable listContributorInsightsPaginator(ListContributorInsightsRequest listContributorInsightsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.CONTRIBUTOR_INSIGHTS_OPERATION_NOT_SUPPORTED);
    }

    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.EXPORT_OPERATION_NOT_SUPPORTED);
    }

    public ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.EXPORT_OPERATION_NOT_SUPPORTED);
    }

    public ListGlobalTablesResponse listGlobalTables() throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.GLOBAL_TABLE_OPERATION_NOT_SUPPORTED);
    }

    public ListGlobalTablesResponse listGlobalTables(ListGlobalTablesRequest listGlobalTablesRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.GLOBAL_TABLE_OPERATION_NOT_SUPPORTED);
    }

    public ListTablesResponse listTables() throws AwsServiceException, SdkClientException {
        ListTablesResponseInfo initResults = this.dbAccess.listTables(null, 100L);
        return (ListTablesResponse)ListTablesResponse.builder().tableNames(initResults.getTableNames()).lastEvaluatedTableName(initResults.getLastEvaluatedTableName()).build();
    }

    public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws AwsServiceException, SdkClientException {
        return new ListTablesFunction(this.dbAccess).apply(listTablesRequest);
    }

    public ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws AwsServiceException, SdkClientException {
        return new ListTablesIterable((DynamoDbClient)this, PaginatorUtils.applyPaginatorUserAgent(listTablesRequest));
    }

    public ListTagsOfResourceResponse listTagsOfResource(ListTagsOfResourceRequest listTagsOfResourceRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.TAGGING_NOT_SUPPORTED);
    }

    public PutItemResponse putItem(PutItemRequest putItemRequest) throws AwsServiceException, SdkClientException {
        return new PutItemFunction(this.dbAccess, this.localDBEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory, TransactionsEnabledMode.TRANSACTIONS_DISABLED).apply(putItemRequest);
    }

    public QueryResponse query(QueryRequest queryRequest) throws AwsServiceException, SdkClientException {
        return new QueryFunction(this.dbAccess, this.localDBEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory).apply(queryRequest);
    }

    public QueryIterable queryPaginator(QueryRequest queryRequest) throws AwsServiceException, SdkClientException {
        return new QueryIterable((DynamoDbClient)this, PaginatorUtils.applyPaginatorUserAgent(queryRequest));
    }

    public RestoreTableFromBackupResponse restoreTableFromBackup(RestoreTableFromBackupRequest restoreTableFromBackupRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.RECOVERY_OPERATION_NOT_SUPPORTED);
    }

    public RestoreTableToPointInTimeResponse restoreTableToPointInTime(RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.RECOVERY_OPERATION_NOT_SUPPORTED);
    }

    public ScanResponse scan(ScanRequest scanRequest) throws AwsServiceException, SdkClientException {
        return new ScanFunction(this.dbAccess, this.localDBEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory).apply(scanRequest);
    }

    public ScanIterable scanPaginator(ScanRequest scanRequest) throws AwsServiceException, SdkClientException {
        return new ScanIterable((DynamoDbClient)this, PaginatorUtils.applyPaginatorUserAgent(scanRequest));
    }

    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.TAGGING_NOT_SUPPORTED);
    }

    public TransactGetItemsResponse transactGetItems(TransactGetItemsRequest transactGetItemsRequest) throws AwsServiceException, SdkClientException {
        return new TransactGetItemsFunction(this.dbAccess, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.localDBEnv).apply(transactGetItemsRequest);
    }

    public TransactWriteItemsResponse transactWriteItems(TransactWriteItemsRequest transactWriteItemsRequest) throws AwsServiceException, SdkClientException {
        AWSExceptionFactory awsExceptionFactory2 = new AWSExceptionFactory();
        return new TransactWriteItemsFunction(this.dbAccess, this.inputConverter, this.localDBOutputConverter, awsExceptionFactory2, this.localDBEnv, this.documentFactory).apply(transactWriteItemsRequest);
    }

    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.TAGGING_NOT_SUPPORTED);
    }

    public UpdateContinuousBackupsResponse updateContinuousBackups(UpdateContinuousBackupsRequest updateContinuousBackupsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.CONTINUOUS_BACKUP_OPERATION_NOT_SUPPORTED);
    }

    public UpdateContributorInsightsResponse updateContributorInsights(UpdateContributorInsightsRequest updateContributorInsightsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.CONTRIBUTOR_INSIGHTS_OPERATION_NOT_SUPPORTED);
    }

    public UpdateGlobalTableResponse updateGlobalTable(UpdateGlobalTableRequest updateGlobalTableRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.GLOBAL_TABLE_OPERATION_NOT_SUPPORTED);
    }

    public UpdateGlobalTableSettingsResponse updateGlobalTableSettings(UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.GLOBAL_TABLE_OPERATION_NOT_SUPPORTED);
    }

    public UpdateItemResponse updateItem(UpdateItemRequest updateItemRequest) throws AwsServiceException, SdkClientException {
        return new UpdateItemFunction(this.dbAccess, this.localDBEnv, this.inputConverter, this.localDBOutputConverter, this.awsExceptionFactory, this.documentFactory, TransactionsEnabledMode.TRANSACTIONS_DISABLED).apply(updateItemRequest);
    }

    public UpdateTableResponse updateTable(UpdateTableRequest updateTableRequest) throws AwsServiceException, SdkClientException {
        return new UpdateTableFunction(this.dbAccess).apply(updateTableRequest);
    }

    public UpdateTableReplicaAutoScalingResponse updateTableReplicaAutoScaling(UpdateTableReplicaAutoScalingRequest updateTableReplicaAutoScalingRequest) throws AwsServiceException, SdkClientException {
        throw this.unknownOperationException(LocalDBClientExceptionMessage.TABLE_REPLICA_AUTO_SCALING_OPERATION_NOT_SUPPORTED);
    }

    public UpdateTimeToLiveResponse updateTimeToLive(UpdateTimeToLiveRequest updateTimeToLiveRequest) throws AwsServiceException, SdkClientException {
        return new UpdateTimeToLiveFunction(this.dbAccess).apply(updateTimeToLiveRequest);
    }

    public DynamoDbWaiter waiter() {
        return DynamoDbWaiter.builder().client((DynamoDbClient)this).build();
    }

    private DynamoDBLocalServiceException unknownOperationException(LocalDBClientExceptionMessage exceptionMessage) {
        return AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.UNKNOWN_OPERATION_EXCEPTION, exceptionMessage.getMessage());
    }
}

