/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.jobs;

import java.util.List;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;
import software.amazon.dynamodb.services.local.shared.jobs.NamedJob;

public class CreateGSIJob
extends NamedJob {
    private final LocalDBAccess dbAccess;
    private final String tableName;
    private final String indexName;

    public CreateGSIJob(String tableName, String indexName, LocalDBAccess dbAccess, JobsRegister jobs) {
        super(jobs);
        this.dbAccess = dbAccess;
        this.tableName = tableName;
        this.indexName = indexName;
    }

    public static String creatingGSIThreadName(String tableName, String indexName) {
        return LocalDBUtils.getGsiThreadName(tableName, indexName, IndexStatus.CREATING);
    }

    @Override
    protected void doJob() {
        if (this.jobs.shouldDelayTransientStatuses()) {
            this.sleepFor(LocalDBUtils.LONG_DELAY_TO_HOLD_TRANSIENT_STATUSES);
        }
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(this.tableName), 10){

            @Override
            public void criticalSection() {
                CreateGSIJob.this.updateGSIState(CreateGSIJob.this.tableName, CreateGSIJob.this.indexName, IndexStatus.CREATING, true);
                CreateGSIJob.this.dbAccess.createGSIColumns(CreateGSIJob.this.tableName, CreateGSIJob.this.indexName);
                CreateGSIJob.this.dbAccess.backfillGSI(CreateGSIJob.this.tableName, CreateGSIJob.this.indexName);
            }
        }.execute();
        if (this.jobs.shouldDelayTransientStatuses()) {
            this.sleepFor(LocalDBUtils.LONG_DELAY_TO_HOLD_TRANSIENT_STATUSES);
        }
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(this.tableName), 10){

            @Override
            public void criticalSection() {
                CreateGSIJob.this.updateGSIState(CreateGSIJob.this.tableName, CreateGSIJob.this.indexName, IndexStatus.ACTIVE, null);
            }
        }.execute();
    }

    private void updateGSIState(String tableName, String indexName, IndexStatus status, Boolean isBackfilling) {
        TableInfo tableInfo = this.dbAccess.getTableInfo(tableName);
        this.dbAccess.updateTable(tableName, tableInfo.getThroughput(), tableInfo.getOndemandThroughput(), tableInfo.getBillingMode(), tableInfo.getLastUpdateToPayPerRequestDateTime(), tableInfo.getAttributeDefinitions(), this.updateGSIStateInThisList(tableInfo, indexName, status, isBackfilling), tableInfo.getDeleteProtectionEnabled(), null);
    }

    private List<GlobalSecondaryIndexDescription> updateGSIStateInThisList(TableInfo tableInfo, String indexName, IndexStatus status, Boolean isBackfilling) {
        List<GlobalSecondaryIndexDescription> gsiDescriptions = tableInfo.getGSIDescriptions();
        for (GlobalSecondaryIndexDescription desc : gsiDescriptions) {
            if (!desc.indexName().equals(indexName)) continue;
            GlobalSecondaryIndexDescription updatedGsi = (GlobalSecondaryIndexDescription)desc.toBuilder().indexStatus(status).backfilling(isBackfilling).build();
            tableInfo.updateGSIDesc(indexName, updatedGsi);
        }
        gsiDescriptions = tableInfo.getGSIDescriptions();
        return gsiDescriptions;
    }

    @Override
    public String name() {
        return LocalDBUtils.getGsiThreadName(this.tableName, this.indexName, IndexStatus.CREATING);
    }

    @Override
    public void cancel() {
        String indexStatus = this.dbAccess.getTableInfo(this.tableName).getGSIDescWithName(this.indexName).indexStatusAsString();
        while (!IndexStatus.ACTIVE.toString().equals(indexStatus)) {
            this.sleepFor(LocalDBUtils.DELAY_BEFORE_SCHEDULING_JOBS_AGAIN);
        }
    }
}

