/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.mapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.Supplier;
import software.amazon.awssdk.utils.builder.SdkBuilder;
import software.amazon.dynamodb.services.local.shared.mapper.DynamoDbObjectMapper;

public class BuilderPatternDeserializer<T, B extends SdkBuilder<B, T>>
extends JsonDeserializer<T> {
    private final Supplier<Class<? extends B>> builderClassSupplier;
    private final Function<B, T> buildFunction;

    public BuilderPatternDeserializer(Supplier<Class<? extends B>> builderClassSupplier, Function<B, T> buildFunction) {
        this.builderClassSupplier = builderClassSupplier;
        this.buildFunction = buildFunction;
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        DynamoDbObjectMapper mapper = (DynamoDbObjectMapper)p.getCodec();
        SdkBuilder builder = (SdkBuilder)mapper.treeToValue((TreeNode)node, this.builderClassSupplier.get());
        return this.buildFunction.apply(builder);
    }
}

