/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.partiql.model;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.DocumentNode;
import ddb.partiql.shared.dbenv.PartiQLDbEnv;
import ddb.partiql.shared.exceptions.ExceptionMessageBuilder;
import ddb.partiql.shared.exceptions.PartiQLBigBirdDataTypeException;
import ddb.partiql.shared.model.PartiQLToAttributeValueConverterBase;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.partiql.lang.ast.ExprNode;
import org.partiql.lang.ast.HasMetas;
import org.partiql.lang.ast.Seq;
import org.partiql.lang.ast.SeqType;
import org.partiql.lang.ast.Struct;
import org.partiql.lang.ast.StructField;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.dataaccess.DynamoDBLocalSharedOpContext;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;

public class PartiQLToAttributeValueConverter
extends PartiQLToAttributeValueConverterBase<DynamoDBLocalSharedOpContext, String, AttributeValue> {
    public PartiQLToAttributeValueConverter(PartiQLDbEnv dbEnv, DocumentFactory documentFactory) {
        super(dbEnv, documentFactory);
    }

    @Override
    protected boolean isBigBirdDataTypeException(RuntimeException rte) {
        return rte instanceof PartiQLBigBirdDataTypeException;
    }

    @Override
    protected String buildBigBirdDataTypeErrorMessage(RuntimeException rte) {
        PartiQLBigBirdDataTypeException partiQLBigBirdDataTypeException = (PartiQLBigBirdDataTypeException)rte;
        return partiQLBigBirdDataTypeException.getErrorCode().toString() + ":" + partiQLBigBirdDataTypeException.getMessage();
    }

    @Override
    protected void validateNestedLevel(int depth) {
        LocalDBValidatorUtils.validateNestedLevel(depth);
    }

    @Override
    protected int validateAndReturnItemSize(AttributeValue attributeValue, int runningItemSizeCount, int maxItemSize, DynamoDBLocalSharedOpContext opContext) {
        int attributeValueSize = (int)LocalDBUtils.getAttributeValueSizeBytes(attributeValue);
        if (attributeValueSize + runningItemSizeCount > maxItemSize) {
            new AWSExceptionFactory().ITEM_TOO_LARGE.throwAsException();
        }
        return attributeValueSize;
    }

    @Override
    protected String makeAttributeName(String name) {
        return name;
    }

    @Override
    protected DocumentNode structToInternalAttributes(Struct struct, int maxItemSize, int depth, String descriptivePathPrefix, DynamoDBLocalSharedOpContext opContext) {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        int runningItemSizeCount = 0;
        for (StructField structField : struct.getFields()) {
            AttributeValue attributeValue;
            ExprNode structNameNode = structField.component1();
            String attributeName = (String)this.exprNodeToInternalAttributeNames(structNameNode, descriptivePathPrefix);
            AttributeValue prevAttributeValue = map.put(attributeName, attributeValue = (AttributeValue)this.safeExprNodeToInternalAttributes(structField.component2(), maxItemSize, depth + 1, PartiQLToAttributeValueConverter.addToDescriptivePath(descriptivePathPrefix, attributeName), opContext));
            if (prevAttributeValue != null) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, new ExceptionMessageBuilder("Duplicate keys in tuple. Key: %s under %s", (HasMetas)struct).build(attributeName, descriptivePathPrefix));
            }
            runningItemSizeCount += attributeName.length();
            runningItemSizeCount += this.validateAndReturnItemSize(attributeValue, runningItemSizeCount, maxItemSize, opContext);
        }
        return new AttributeValue().withM(map);
    }

    @Override
    protected DocumentNode listToInternalAttributes(Seq seq, int maxItemSize, int depth, String descriptivePathPrefix, DynamoDBLocalSharedOpContext opContext) {
        this.dbEnv.dbPqlAssert(seq.getType().equals((Object)SeqType.LIST), "listToInternalAttributes", "only LIST seq type can be converted to a DynamoDB list", "seqType", seq.getType());
        ArrayList<AttributeValue> list = new ArrayList<AttributeValue>();
        int runningItemSizeCount = 0;
        int listInd = 0;
        for (ExprNode node : seq.getValues()) {
            AttributeValue attributeValue = (AttributeValue)this.safeExprNodeToInternalAttributes(node, maxItemSize, depth + 1, PartiQLToAttributeValueConverter.addToDescriptivePath(descriptivePathPrefix, Integer.toString(listInd)), opContext);
            list.add(attributeValue);
            runningItemSizeCount += this.validateAndReturnItemSize(attributeValue, runningItemSizeCount, maxItemSize, opContext);
            ++listInd;
        }
        return new AttributeValue().withL(list);
    }

    @Override
    protected DocumentNode stringListToInternalAttributes(List<String> stringList) {
        return this.documentFactory.makeStringSet(stringList);
    }

    @Override
    protected DocumentNode numberListToInternalAttributes(List<BigDecimal> numberList) {
        return this.documentFactory.makeNumberSet(numberList);
    }
}

