/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.partiql.processor;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.partiql.lang.ast.DataManipulation;
import org.partiql.lang.ast.DataManipulationOperation;
import org.partiql.lang.ast.Select;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementError;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.exceptions.DynamoDBLocalServiceException;
import software.amazon.dynamodb.services.local.embedded.DDBExceptionMappingInvocationHandler;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.api.dp.BatchExecuteStatementFunction;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.model.TranslatedPartiQLOperation;
import software.amazon.dynamodb.services.local.shared.partiql.processor.PartiQLProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.translator.SelectStatementTranslator;
import software.amazon.dynamodb.services.local.shared.partiql.util.ObjectExceptionPair;

public abstract class BatchProcessor
extends PartiQLProcessor {
    public static final String PARTIQL_BATCH_PAYLOAD_TOO_LARGE = "BatchExecuteStatement payload size cannot exceed 16MB. Payload Size: %s";
    public static final String RESOURCE_NOT_FOUND_CODE = "ResourceNotFound";

    protected BatchProcessor(LocalDBAccess dbAccess, LocalPartiQLDbEnv localPartiQLDbEnv, BatchExecuteStatementFunction batchExecuteStatementFunction, DocumentFactory documentFactory) {
        super(dbAccess, localPartiQLDbEnv, batchExecuteStatementFunction, documentFactory);
    }

    public abstract BatchExecuteStatementResponse execute(List<ObjectExceptionPair<ParsedPartiQLRequest>> var1);

    protected List<ObjectExceptionPair<TranslatedPartiQLOperation>> performTranslations(List<ObjectExceptionPair<ParsedPartiQLRequest>> parsedPartiQLRequestExceptionPairs) {
        ArrayList<ObjectExceptionPair<TranslatedPartiQLOperation>> translatedPartiQLOperationExceptionPairs = new ArrayList<ObjectExceptionPair<TranslatedPartiQLOperation>>();
        for (ObjectExceptionPair<ParsedPartiQLRequest> parsedPartiQLRequestExceptionPair : parsedPartiQLRequestExceptionPairs) {
            try {
                if (parsedPartiQLRequestExceptionPair.hasException()) {
                    throw parsedPartiQLRequestExceptionPair.getException();
                }
                ParsedPartiQLRequest parsedPartiQLRequest = parsedPartiQLRequestExceptionPair.getObject();
                Object exprNode = parsedPartiQLRequest.getExprNode();
                Class<?> opClass = exprNode instanceof DataManipulation ? ((DataManipulationOperation)((DataManipulation)exprNode).getDmlOperations().getOps().get(0)).getClass() : exprNode.getClass();
                TranslatedPartiQLOperation translatedPartiQLOperation = Select.class.equals(opClass) ? ((SelectStatementTranslator)this.partiQLStatementFunction.statementTranslators.get(opClass)).translate(parsedPartiQLRequest, SelectStatementTranslator.SelectUseCase.BATCH) : this.partiQLStatementFunction.statementTranslators.get(opClass).translate(parsedPartiQLRequest);
                translatedPartiQLOperationExceptionPairs.add(new ObjectExceptionPair<TranslatedPartiQLOperation>(translatedPartiQLOperation, null));
            }
            catch (DynamoDBLocalServiceException e) {
                translatedPartiQLOperationExceptionPairs.add(new ObjectExceptionPair<Object>(null, e));
            }
        }
        return translatedPartiQLOperationExceptionPairs;
    }

    protected static BatchStatementResponse convertInternalExceptionToBatchStatementResponse(DynamoDBLocalServiceException localServiceException, String tableName) {
        String code = localServiceException.getErrorCode();
        code = BatchProcessor.getErrorCode(code);
        if (localServiceException.getItem() == null) {
            return (BatchStatementResponse)BatchStatementResponse.builder().error((BatchStatementError)BatchStatementError.builder().code(code).message(localServiceException.getMessage()).build()).tableName(tableName).build();
        }
        Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> items = BatchProcessor.createItemMap(localServiceException);
        return (BatchStatementResponse)BatchStatementResponse.builder().error((BatchStatementError)BatchStatementError.builder().code(code).item(items).message(localServiceException.getMessage()).build()).tableName(tableName).build();
    }

    @VisibleForTesting
    @NotNull
    static Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> createItemMap(DynamoDBLocalServiceException localServiceException) {
        Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> items = localServiceException.getItem().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> DDBExceptionMappingInvocationHandler.convertAttributeValue((AttributeValue)e.getValue())));
        return items;
    }

    @NotNull
    static String getErrorCode(String code) {
        if (code.equals(AmazonServiceExceptionType.VALIDATION_EXCEPTION.getErrorCode())) {
            code = "ValidationError";
        } else if (code.equals(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION.getErrorCode())) {
            code = "ConditionalCheckFailed";
        } else if (code.equals(AmazonServiceExceptionType.RESOURCE_NOT_FOUND_EXCEPTION.getErrorCode())) {
            code = RESOURCE_NOT_FOUND_CODE;
        }
        return code;
    }
}

