/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core;

import java.util.Objects;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class SplittingTransformerConfiguration
implements ToCopyableBuilder<Builder, SplittingTransformerConfiguration> {
    private final Long bufferSizeInBytes;

    private SplittingTransformerConfiguration(DefaultBuilder builder) {
        this.bufferSizeInBytes = (Long)Validate.paramNotNull((Object)builder.bufferSize, (String)"bufferSize");
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public Long bufferSizeInBytes() {
        return this.bufferSizeInBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplittingTransformerConfiguration that = (SplittingTransformerConfiguration)o;
        return Objects.equals(this.bufferSizeInBytes, that.bufferSizeInBytes);
    }

    public int hashCode() {
        return this.bufferSizeInBytes != null ? this.bufferSizeInBytes.hashCode() : 0;
    }

    public String toString() {
        return ToString.builder((String)"SplittingTransformerConfiguration").add("bufferSizeInBytes", (Object)this.bufferSizeInBytes).build();
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    private static final class DefaultBuilder
    implements Builder {
        private Long bufferSize;

        private DefaultBuilder(SplittingTransformerConfiguration configuration) {
            this.bufferSize = configuration.bufferSizeInBytes;
        }

        private DefaultBuilder() {
        }

        @Override
        public Builder bufferSizeInBytes(Long bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public SplittingTransformerConfiguration build() {
            return new SplittingTransformerConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SplittingTransformerConfiguration> {
        public Builder bufferSizeInBytes(Long var1);
    }
}

