/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
@ThreadSafe
public final class EmittingSubscription<T>
implements Subscription {
    private static final Logger log = Logger.loggerFor(EmittingSubscription.class);
    private Subscriber<? super T> downstreamSubscriber;
    private final AtomicBoolean emitting;
    private final AtomicLong outstandingDemand;
    private final Runnable onCancel;
    private final AtomicBoolean isCancelled;
    private final Supplier<T> supplier;

    private EmittingSubscription(Builder<T> builder) {
        this.downstreamSubscriber = ((Builder)builder).downstreamSubscriber;
        this.onCancel = ((Builder)builder).onCancel;
        this.supplier = ((Builder)builder).supplier;
        this.isCancelled = new AtomicBoolean();
        this.outstandingDemand = new AtomicLong(0L);
        this.emitting = new AtomicBoolean();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public void request(long n) {
        if (n <= 0L) {
            this.downstreamSubscriber.onError((Throwable)new IllegalArgumentException("Amount requested must be positive"));
            return;
        }
        long newDemand = this.outstandingDemand.updateAndGet(current -> {
            if (Long.MAX_VALUE - current < n) {
                return Long.MAX_VALUE;
            }
            return current + n;
        });
        log.trace(() -> String.format("new outstanding demand: %s", newDemand));
        this.emit();
    }

    public void cancel() {
        this.isCancelled.set(true);
        this.downstreamSubscriber = null;
        this.onCancel.run();
    }

    private void emit() {
        do {
            if (!this.emitting.compareAndSet(false, true)) {
                return;
            }
            try {
                if (this.doEmit()) {
                    return;
                }
            }
            finally {
                this.emitting.compareAndSet(true, false);
            }
        } while (this.outstandingDemand.get() > 0L);
    }

    private boolean doEmit() {
        long demand = this.outstandingDemand.get();
        while (demand > 0L) {
            T value;
            if (this.isCancelled.get()) {
                return true;
            }
            if (this.outstandingDemand.get() <= 0L) continue;
            demand = this.outstandingDemand.decrementAndGet();
            try {
                value = this.supplier.get();
            }
            catch (Exception e) {
                this.downstreamSubscriber.onError((Throwable)e);
                return true;
            }
            this.downstreamSubscriber.onNext(value);
        }
        return false;
    }

    public static class Builder<T> {
        private Subscriber<? super T> downstreamSubscriber;
        private Runnable onCancel;
        private Supplier<T> supplier;

        public Builder<T> downstreamSubscriber(Subscriber<? super T> subscriber) {
            this.downstreamSubscriber = subscriber;
            return this;
        }

        public Builder<T> onCancel(Runnable onCancel) {
            this.onCancel = onCancel;
            return this;
        }

        public Builder<T> supplier(Supplier<T> supplier) {
            this.supplier = supplier;
            return this;
        }

        public EmittingSubscription<T> build() {
            return new EmittingSubscription(this);
        }
    }
}

