/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.FileTransformerConfiguration;
import software.amazon.awssdk.core.SdkResponse;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.internal.async.EmittingSubscription;
import software.amazon.awssdk.core.internal.async.FileAsyncResponseTransformer;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.ContentRangeParser;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class FileAsyncResponseTransformerPublisher<T extends SdkResponse>
implements SdkPublisher<AsyncResponseTransformer<T, T>> {
    private final Path path;
    private final FileTransformerConfiguration initialConfig;
    private Subscriber<?> subscriber;
    private final AtomicLong transformerCount;

    public FileAsyncResponseTransformerPublisher(FileAsyncResponseTransformer<?> responseTransformer) {
        this.path = (Path)Validate.paramNotNull((Object)responseTransformer.path(), (String)"path");
        Validate.isTrue((responseTransformer.config().fileWriteOption() != FileTransformerConfiguration.FileWriteOption.CREATE_OR_APPEND_TO_EXISTING ? 1 : 0) != 0, (String)"CREATE_OR_APPEND_TO_EXISTING is not supported for non-serial operations", (Object[])new Object[0]);
        this.initialConfig = (FileTransformerConfiguration)Validate.paramNotNull((Object)responseTransformer.config(), (String)"fileTransformerConfiguration");
        this.transformerCount = new AtomicLong(0L);
    }

    public void subscribe(Subscriber<? super AsyncResponseTransformer<T, T>> s) {
        Validate.notNull(s, (String)"Subscriber must not be null", (Object[])new Object[0]);
        this.subscriber = s;
        s.onSubscribe(EmittingSubscription.builder().downstreamSubscriber(s).onCancel(this::onCancel).supplier(this::createTransformer).build());
    }

    private AsyncResponseTransformer<T, T> createTransformer() {
        return new IndividualFileTransformer();
    }

    private void onCancel() {
        this.subscriber = null;
    }

    private class IndividualFileTransformer
    implements AsyncResponseTransformer<T, T> {
        private AsyncResponseTransformer<T, T> delegate;
        private CompletableFuture<T> future;

        private IndividualFileTransformer() {
        }

        @Override
        public CompletableFuture<T> prepare() {
            this.future = new CompletableFuture();
            return this.future;
        }

        @Override
        public void onResponse(T response) {
            String contentRange;
            Optional contentRangePair;
            Optional<String> contentRangeOpt = ((SdkResponse)response).sdkHttpResponse().firstMatchingHeader("x-amz-content-range");
            if (!contentRangeOpt.isPresent() && !(contentRangeOpt = ((SdkResponse)response).sdkHttpResponse().firstMatchingHeader("content-range")).isPresent()) {
                Optional contentLength = ((SdkResponse)response).sdkHttpResponse().firstMatchingHeader("content-length");
                long transformerCount = FileAsyncResponseTransformerPublisher.this.transformerCount.get();
                if (FileAsyncResponseTransformerPublisher.this.subscriber != null && transformerCount > 0L) {
                    FileAsyncResponseTransformerPublisher.this.subscriber.onError((Throwable)new IllegalStateException("Content range header is missing"));
                    return;
                }
                if (!contentLength.isPresent()) {
                    FileAsyncResponseTransformerPublisher.this.subscriber.onError((Throwable)new IllegalStateException("Content length header is missing"));
                    return;
                }
                String totalLength = (String)contentLength.get();
                long endByte = Long.parseLong(totalLength) - 1L;
                contentRangeOpt = Optional.of("bytes 0-" + endByte + "/" + totalLength);
            }
            if (!(contentRangePair = ContentRangeParser.range((String)(contentRange = (String)contentRangeOpt.get()))).isPresent()) {
                if (FileAsyncResponseTransformerPublisher.this.subscriber != null) {
                    IllegalStateException e = new IllegalStateException("Could not parse content range header " + contentRange);
                    this.handleError(e);
                }
                return;
            }
            this.delegate = this.getDelegateTransformer((Long)((Pair)contentRangePair.get()).left());
            CompletableFuture delegateFuture = this.delegate.prepare();
            CompletableFutureUtils.forwardResultTo(delegateFuture, this.future);
            CompletableFutureUtils.forwardExceptionTo(this.future, delegateFuture);
            FileAsyncResponseTransformerPublisher.this.transformerCount.incrementAndGet();
            this.delegate.onResponse(response);
        }

        private void handleError(Throwable e) {
            FileAsyncResponseTransformerPublisher.this.subscriber.onError(e);
            this.future.completeExceptionally(e);
        }

        private AsyncResponseTransformer<T, T> getDelegateTransformer(Long startAt) {
            if (FileAsyncResponseTransformerPublisher.this.transformerCount.get() == 0L && FileAsyncResponseTransformerPublisher.this.initialConfig.fileWriteOption() != FileTransformerConfiguration.FileWriteOption.WRITE_TO_POSITION) {
                return AsyncResponseTransformer.toFile(FileAsyncResponseTransformerPublisher.this.path, FileAsyncResponseTransformerPublisher.this.initialConfig);
            }
            switch (FileAsyncResponseTransformerPublisher.this.initialConfig.fileWriteOption()) {
                case CREATE_NEW: 
                case CREATE_OR_REPLACE_EXISTING: {
                    FileTransformerConfiguration newConfig = (FileTransformerConfiguration)FileAsyncResponseTransformerPublisher.this.initialConfig.copy(c -> c.fileWriteOption(FileTransformerConfiguration.FileWriteOption.WRITE_TO_POSITION).position(startAt));
                    return AsyncResponseTransformer.toFile(FileAsyncResponseTransformerPublisher.this.path, newConfig);
                }
                case WRITE_TO_POSITION: {
                    long initialOffset = FileAsyncResponseTransformerPublisher.this.initialConfig.position();
                    FileTransformerConfiguration newConfig = (FileTransformerConfiguration)FileAsyncResponseTransformerPublisher.this.initialConfig.copy(c -> c.fileWriteOption(FileTransformerConfiguration.FileWriteOption.WRITE_TO_POSITION).position(initialOffset + startAt));
                    return AsyncResponseTransformer.toFile(FileAsyncResponseTransformerPublisher.this.path, newConfig);
                }
            }
            throw new UnsupportedOperationException("Unsupported fileWriteOption: " + (Object)((Object)FileAsyncResponseTransformerPublisher.this.initialConfig.fileWriteOption()));
        }

        @Override
        public void onStream(SdkPublisher<ByteBuffer> publisher) {
            if (this.delegate == null) {
                if (this.future != null) {
                    this.future.completeExceptionally(new IllegalStateException("onStream called before onResponse"));
                }
                return;
            }
            this.delegate.onStream(publisher);
        }

        @Override
        public void exceptionOccurred(Throwable error) {
            if (this.delegate != null) {
                this.delegate.exceptionOccurred(error);
            } else if (this.future != null) {
                this.future.completeExceptionally(error);
            }
        }
    }
}

