/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.http.pipeline.stages;

import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.http.HttpClientDependencies;
import software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import software.amazon.awssdk.core.internal.http.pipeline.stages.utils.RetryableStageHelper;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
public final class AsyncRetryableStage<OutputT>
implements RequestPipeline<SdkHttpFullRequest, CompletableFuture<Response<OutputT>>> {
    private final TransformingAsyncResponseHandler<Response<OutputT>> responseHandler;
    private final RequestPipeline<SdkHttpFullRequest, CompletableFuture<Response<OutputT>>> requestPipeline;
    private final ScheduledExecutorService scheduledExecutor;
    private final HttpClientDependencies dependencies;

    public AsyncRetryableStage(TransformingAsyncResponseHandler<Response<OutputT>> responseHandler, HttpClientDependencies dependencies, RequestPipeline<SdkHttpFullRequest, CompletableFuture<Response<OutputT>>> requestPipeline) {
        this.responseHandler = responseHandler;
        this.dependencies = dependencies;
        this.scheduledExecutor = dependencies.clientConfiguration().option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
        this.requestPipeline = requestPipeline;
    }

    @Override
    public CompletableFuture<Response<OutputT>> execute(SdkHttpFullRequest request, RequestExecutionContext context) throws Exception {
        return new RetryingExecutor(request, context).execute();
    }

    private final class RetryingExecutor {
        private final AsyncRequestBody originalRequestBody;
        private final RequestExecutionContext context;
        private final RetryableStageHelper retryableStageHelper;

        private RetryingExecutor(SdkHttpFullRequest request, RequestExecutionContext context) {
            this.originalRequestBody = context.requestProvider();
            this.context = context;
            this.retryableStageHelper = new RetryableStageHelper(request, context, AsyncRetryableStage.this.dependencies);
        }

        public CompletableFuture<Response<OutputT>> execute() {
            CompletableFuture future = new CompletableFuture();
            try {
                this.attemptFirstExecute(future);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
            return future;
        }

        public void attemptFirstExecute(CompletableFuture<Response<OutputT>> future) {
            Duration backoffDelay = this.retryableStageHelper.acquireInitialToken();
            if (backoffDelay.isZero()) {
                this.attemptExecute(future);
            } else {
                this.retryableStageHelper.logBackingOff(backoffDelay);
                long totalDelayMillis = backoffDelay.toMillis();
                AsyncRetryableStage.this.scheduledExecutor.schedule(() -> this.attemptExecute(future), totalDelayMillis, TimeUnit.MILLISECONDS);
            }
        }

        private void attemptExecute(CompletableFuture<Response<OutputT>> future) {
            CompletableFuture responseFuture;
            try {
                this.retryableStageHelper.startingAttempt();
                this.retryableStageHelper.logSendingRequest();
                responseFuture = (CompletableFuture)AsyncRetryableStage.this.requestPipeline.execute(this.retryableStageHelper.requestToSend(), this.context);
                CompletableFutureUtils.forwardExceptionTo(future, (CompletableFuture)responseFuture);
            }
            catch (IOException | SdkException e) {
                this.maybeRetryExecute(future, e);
                return;
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                return;
            }
            responseFuture.whenComplete((response, exception) -> {
                if (exception != null) {
                    if (exception instanceof Exception) {
                        this.maybeRetryExecute(future, (Exception)exception);
                    } else {
                        future.completeExceptionally((Throwable)exception);
                    }
                    return;
                }
                this.retryableStageHelper.setLastResponse((SdkHttpResponse)response.httpResponse());
                if (!response.isSuccess().booleanValue()) {
                    this.retryableStageHelper.adjustClockIfClockSkew((Response<?>)response);
                    this.maybeRetryExecute(future, response.exception());
                    return;
                }
                this.retryableStageHelper.recordAttemptSucceeded();
                future.complete((Response)response);
            });
        }

        public void maybeAttemptExecute(CompletableFuture<Response<OutputT>> future) {
            Optional<Duration> delay = this.retryableStageHelper.tryRefreshToken(Duration.ZERO);
            if (!delay.isPresent()) {
                future.completeExceptionally(this.retryableStageHelper.retryPolicyDisallowedRetryException());
                return;
            }
            AsyncRetryableStage.this.responseHandler.onError(this.retryableStageHelper.getLastException());
            this.context.requestProvider(this.originalRequestBody);
            Duration backoffDelay = delay.get();
            this.retryableStageHelper.logBackingOff(backoffDelay);
            long totalDelayMillis = backoffDelay.toMillis();
            AsyncRetryableStage.this.scheduledExecutor.schedule(() -> this.attemptExecute(future), totalDelayMillis, TimeUnit.MILLISECONDS);
        }

        private void maybeRetryExecute(CompletableFuture<Response<OutputT>> future, Exception exception) {
            this.retryableStageHelper.setLastException(exception);
            try {
                this.maybeAttemptExecute(future);
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }
    }
}

