/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.useragent;

import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.utils.OptionalUtils;

@SdkInternalApi
public final class AppIdResolver {
    private Supplier<ProfileFile> profileFile;
    private String profileName;

    private AppIdResolver() {
    }

    public static AppIdResolver create() {
        return new AppIdResolver();
    }

    public AppIdResolver profileFile(Supplier<ProfileFile> profileFile) {
        this.profileFile = profileFile;
        return this;
    }

    public AppIdResolver profileName(String profileName) {
        this.profileName = profileName;
        return this;
    }

    public Optional<String> resolve() {
        return OptionalUtils.firstPresent(this.fromSystemSettings(), (Supplier[])new Supplier[]{() -> this.fromProfileFile(this.profileFile, this.profileName)});
    }

    private Optional<String> fromSystemSettings() {
        return SdkSystemSetting.AWS_SDK_UA_APP_ID.getStringValue();
    }

    private Optional<String> fromProfileFile(Supplier<ProfileFile> profileFile, String profileName) {
        profileFile = profileFile != null ? profileFile : ProfileFile::defaultProfileFile;
        profileName = profileName != null ? profileName : ProfileFileSystemSetting.AWS_PROFILE.getStringValueOrThrow();
        return profileFile.get().profile(profileName).flatMap(p -> p.property("sdk_ua_app_id"));
    }
}

