/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.useragent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkProtectedApi
public class BusinessMetricCollection {
    public static final int MAX_METRICS_STRING_IN_BYTES = 1024;
    public static final UnaryOperator<String> METRIC_SEARCH_PATTERN = metric -> ".*m/[a-zA-Z0-9+-,]*" + metric + ".*";
    private final List<String> recordedMetrics = new ArrayList<String>();
    private final int maxLengthInBytes;

    public BusinessMetricCollection() {
        this(1024);
    }

    public BusinessMetricCollection(int maxMetricsStringInBytes) {
        this.maxLengthInBytes = maxMetricsStringInBytes;
    }

    public List<String> recordedMetrics() {
        return Collections.unmodifiableList(this.recordedMetrics);
    }

    public void addMetric(String metric) {
        this.recordedMetrics.add(metric);
    }

    public void merge(Collection<String> additionalMetrics) {
        if (!CollectionUtils.isNullOrEmpty(additionalMetrics)) {
            this.recordedMetrics.addAll(additionalMetrics);
        }
    }

    public String asBoundedString() {
        String recordedMetricsString = String.join((CharSequence)",", this.recordedMetrics);
        return BusinessMetricCollection.checkSizeAndShortenIfNeeded(recordedMetricsString, this.maxLengthInBytes);
    }

    private static String checkSizeAndShortenIfNeeded(String commaSeparated, int maxAllowableLength) {
        if (commaSeparated.length() <= maxAllowableLength) {
            return commaSeparated;
        }
        return BusinessMetricCollection.shortenToBeforeNearestComma(commaSeparated, maxAllowableLength);
    }

    private static String shortenToBeforeNearestComma(String commaSeparated, int maxAllowableLength) {
        boolean endsOnComma;
        boolean endsBeforeComma;
        boolean bl = endsBeforeComma = commaSeparated.charAt(maxAllowableLength) == ',';
        if (endsBeforeComma) {
            return commaSeparated.substring(0, maxAllowableLength);
        }
        boolean bl2 = endsOnComma = commaSeparated.charAt(maxAllowableLength - 1) == ',';
        if (endsOnComma) {
            return commaSeparated.substring(0, maxAllowableLength - 1);
        }
        String maxAllowableString = commaSeparated.substring(0, maxAllowableLength);
        int lastCommaIndex = maxAllowableString.lastIndexOf(44);
        return maxAllowableString.substring(0, lastCommaIndex);
    }
}

