/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SQLParts {
    private static final String[] PARAMS_STRINGS = new String[101];
    private final List<String> myParts;
    private int myHash;
    private String mySql;
    private boolean myFixed;

    public SQLParts() {
        this.myParts = new ArrayList<String>(5);
    }

    public SQLParts(SQLParts copyFrom) {
        this.myParts = new ArrayList<String>(copyFrom == null ? 5 : copyFrom.myParts.size());
        if (copyFrom != null) {
            this.myParts.addAll(copyFrom.myParts);
        }
    }

    public SQLParts(String sql) {
        this.myParts = new ArrayList<String>(1);
        this.append(sql);
    }

    public SQLParts fix() {
        this.myFixed = true;
        return this;
    }

    public SQLParts getFixedParts() {
        return this.myFixed ? this : new SQLParts(this).fix();
    }

    public int hashCode() {
        if (this.myHash == 0) {
            this.myHash = this.calcHash();
        }
        return this.myHash;
    }

    private int calcHash() {
        int r = 0;
        for (String myPart : this.myParts) {
            r = 31 * r + myPart.hashCode();
        }
        return r;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        List<String> other = ((SQLParts)o).myParts;
        if (this.myParts.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.myParts.size(); ++i) {
            if (this.myParts.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        if (this.myFixed) {
            throw new IllegalStateException(String.valueOf(this));
        }
        this.myParts.clear();
        this.dropCachedValues();
    }

    public SQLParts append(String part) {
        if (this.myFixed) {
            throw new IllegalStateException(String.valueOf(this));
        }
        if (part != null && part.length() > 0) {
            this.myParts.add(part);
            this.dropCachedValues();
        }
        return this;
    }

    public SQLParts append(SQLParts parts) {
        if (this.myFixed) {
            throw new IllegalStateException(String.valueOf(this));
        }
        if (parts != null && !parts.myParts.isEmpty()) {
            this.myParts.addAll(parts.myParts);
            this.dropCachedValues();
        }
        return this;
    }

    public SQLParts appendParams(int count) {
        return this.append(this.getParamsString(count));
    }

    private String getParamsString(int count) {
        if (count < 1) {
            return null;
        }
        if (count >= PARAMS_STRINGS.length) {
            return this.createParamsString(count);
        }
        String s = PARAMS_STRINGS[count];
        if (s == null) {
            s = SQLParts.PARAMS_STRINGS[count] = this.createParamsString(count);
        }
        return s;
    }

    private String createParamsString(int count) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append('?');
        }
        return b.toString();
    }

    private void dropCachedValues() {
        this.myHash = 0;
        this.mySql = null;
    }

    public String toString() {
        if (this.mySql == null) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.myParts.size(); ++i) {
                builder.append(this.myParts.get(i));
            }
            this.mySql = builder.toString();
        }
        return this.mySql;
    }

    public List<String> getParts() {
        return Collections.unmodifiableList(this.myParts);
    }

    public boolean isFixed() {
        return this.myFixed;
    }
}

