/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.Internal;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class SQLiteProfiler {
    private static final String HEADER = "-----------------------------------------------------------------------------";
    private final Map<String, SQLStat> myStats = new HashMap<String, SQLStat>();

    public void printReport(PrintWriter out) {
        ArrayList<SQLStat> stats = new ArrayList<SQLStat>(this.myStats.values());
        Collections.sort(stats, new Comparator<SQLStat>(){

            @Override
            public int compare(SQLStat o1, SQLStat o2) {
                return o1.getTotalTime() < o2.getTotalTime() ? 1 : -1;
            }
        });
        for (SQLStat stat : stats) {
            stat.printReport(out);
        }
    }

    public String printReport() {
        StringWriter sw = new StringWriter();
        this.printReport(new PrintWriter(sw));
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printReport(String file) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(fos));
            this.printReport(writer);
            writer.close();
        }
        catch (IOException e) {
            Internal.logWarn(this, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void reportExec(String sql, long nfrom, long nto, int rc) {
        this.getStat(sql).report(rc == 0 ? "exec" : "exec:error(" + rc + ")", nfrom, nto);
    }

    void reportPrepare(String sql, long nfrom, long nto, int rc) {
        this.getStat(sql).report(rc == 0 ? "prepare" : "prepare:error(" + rc + ")", nfrom, nto);
    }

    void reportStep(boolean alreadyStepped, String sql, long nfrom, long nto, int rc) {
        SQLStat stat = this.getStat(sql);
        if (rc != 100 && rc != 101) {
            stat.report("step:error(" + rc + ")", nfrom, nto);
            return;
        }
        stat.report("step", nfrom, nto);
        if (alreadyStepped || rc == 100) {
            stat.report(alreadyStepped ? "step:next" : "step:first", nfrom, nto);
        }
    }

    void reportLoadInts(boolean alreadyStepped, String sql, long nfrom, long nto, int rc, int count) {
        SQLStat stat = this.getStat(sql);
        if (rc != 100 && rc != 101) {
            stat.report("loadInts:error(" + rc + ")", nfrom, nto);
            return;
        }
        stat.report("loadInts", nfrom, nto);
        if (alreadyStepped || rc == 100) {
            stat.report(alreadyStepped ? "loadInts:next" : "loadInts:first", nfrom, nto);
        }
    }

    void reportLoadLongs(boolean alreadyStepped, String sql, long nfrom, long nto, int rc, int count) {
        SQLStat stat = this.getStat(sql);
        if (rc != 100 && rc != 101) {
            stat.report("loadLongs:error(" + rc + ")", nfrom, nto);
            return;
        }
        stat.report("loadLongs", nfrom, nto);
        if (alreadyStepped || rc == 100) {
            stat.report(alreadyStepped ? "loadLongs:next" : "loadLongs:first", nfrom, nto);
        }
    }

    private SQLStat getStat(String sql) {
        SQLStat stat = this.myStats.get(sql);
        if (stat == null) {
            stat = new SQLStat(sql);
            this.myStats.put(sql, stat);
        }
        return stat;
    }

    private static String formatDuration(long nanos) {
        if (nanos > 1000000000L) {
            return String.format(Locale.US, "%.1fs", (double)nanos / 1.0E9);
        }
        if (nanos > 100000000L) {
            return String.format(Locale.US, "%dms", nanos / 1000000L);
        }
        if (nanos > 10000000L) {
            return String.format(Locale.US, "%.1fms", (double)nanos / 1000000.0);
        }
        if (nanos > 100000L) {
            return String.format(Locale.US, "%.2fms", (double)nanos / 1000000.0);
        }
        return String.format(Locale.US, "%.2fmks", (double)nanos / 1000.0);
    }

    private static class Stat {
        private int myTotalCount;
        private long myTotalNanos;
        private long myMinNanos = -1L;
        private long myMaxNanos = -1L;
        private long myFirstTime;
        private long myLastTime;

        private Stat() {
        }

        public void report(long nfrom, long nto) {
            long duration = nto - nfrom;
            if (duration < 0L) {
                return;
            }
            ++this.myTotalCount;
            this.myTotalNanos += duration;
            if (this.myMinNanos < 0L || duration < this.myMinNanos) {
                this.myMinNanos = duration;
            }
            if (this.myMaxNanos < 0L || duration > this.myMaxNanos) {
                this.myMaxNanos = duration;
            }
            this.myLastTime = System.currentTimeMillis();
            if (this.myFirstTime == 0L) {
                this.myFirstTime = this.myLastTime;
            }
        }

        public long getTotalNanos() {
            return this.myTotalNanos;
        }

        public int getTotalCount() {
            return this.myTotalCount;
        }

        public long getMinNanos() {
            return this.myMinNanos;
        }

        public long getAvgNanos() {
            return this.myTotalCount > 0 ? this.myTotalNanos / (long)this.myTotalCount : 0L;
        }

        public long getMaxNanos() {
            return this.myMaxNanos;
        }

        public String getFrequency() {
            if (this.myTotalCount < 10) {
                return "-";
            }
            long millis = this.myLastTime - this.myFirstTime;
            long t = millis / (long)this.myTotalCount;
            if (t == 0L) {
                return "-";
            }
            return "1/" + SQLiteProfiler.formatDuration(t * 1000000L);
        }
    }

    private static class SQLStat {
        private final String mySQL;
        private final Map<String, Stat> myStats = new TreeMap<String, Stat>();

        public SQLStat(String sql) {
            this.mySQL = sql;
        }

        public String getSQL() {
            return this.mySQL;
        }

        public void report(String name, long nfrom, long nto) {
            Stat stat = this.myStats.get(name);
            if (stat == null) {
                stat = new Stat();
                this.myStats.put(name, stat);
            }
            stat.report(nfrom, nto);
        }

        public long getTotalTime() {
            long total = 0L;
            for (Stat stat : this.myStats.values()) {
                total += stat.myTotalNanos;
            }
            return total;
        }

        public void printReport(PrintWriter out) {
            out.println(SQLiteProfiler.HEADER);
            out.println(this.mySQL);
            out.println(SQLiteProfiler.HEADER);
            String totalPrefix = "total time";
            int maxPrefix = totalPrefix.length();
            for (String s : this.myStats.keySet()) {
                maxPrefix = Math.max(maxPrefix, s.length());
            }
            StringBuilder b = new StringBuilder();
            this.addLeftColumn(b, totalPrefix, maxPrefix);
            b.append(SQLiteProfiler.formatDuration(this.getTotalTime()));
            out.println(b.toString());
            for (Map.Entry<String, Stat> e : this.myStats.entrySet()) {
                b.setLength(0);
                this.addLeftColumn(b, e.getKey(), maxPrefix);
                Stat stat = e.getValue();
                b.append("total:").append(SQLiteProfiler.formatDuration(stat.getTotalNanos())).append(' ');
                b.append("count:").append(stat.getTotalCount()).append(' ');
                b.append("min|avg|max:").append(SQLiteProfiler.formatDuration(stat.getMinNanos())).append('|').append(SQLiteProfiler.formatDuration(stat.getAvgNanos())).append('|').append(SQLiteProfiler.formatDuration(stat.getMaxNanos())).append(' ');
                b.append("freq:").append(stat.getFrequency());
                out.println(b.toString());
            }
            out.println();
        }

        private void addLeftColumn(StringBuilder b, String name, int maxPrefix) {
            b.append("    ");
            b.append(name);
            for (int add = maxPrefix + 4 - b.length(); add > 0; --add) {
                b.append(' ');
            }
            b.append("   ");
        }
    }
}

