/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class SocialMessagingServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "social-messaging";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-6"), Region.of("ca-central-1"), Region.of("ca-west-1"), Region.of("eu-central-1"), Region.of("eu-north-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("fips-ca-central-1"), Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-2"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("mx-central-1"), Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-2"), Region.of("eusc-de-east-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-eusc", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), (Object)"af-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), (Object)"ap-northeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), (Object)"ap-northeast-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), (Object)"ap-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), (Object)"ap-south-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), (Object)"ap-southeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), (Object)"ap-southeast-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), (Object)"ap-southeast-6").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), (Object)"ca-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("fips")).build(), (Object)"ca-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"ca-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), (Object)"ca-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"ca-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"ca-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), (Object)"eu-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), (Object)"eu-north-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), (Object)"eu-south-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), (Object)"eu-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), (Object)"eu-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), (Object)"ca-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), (Object)"me-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), (Object)"me-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), (Object)"mx-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), (Object)"sa-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eusc-de-east-1")).build(), (Object)"eusc-de-east-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().allowDuplicateKeys(true).put((Object)ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), (Object)"social-messaging.af-south-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), (Object)"social-messaging.ap-northeast-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), (Object)"social-messaging.ap-northeast-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), (Object)"social-messaging.ap-south-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), (Object)"social-messaging.ap-south-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), (Object)"social-messaging.ap-southeast-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), (Object)"social-messaging.ap-southeast-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), (Object)"social-messaging.ap-southeast-6.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), (Object)"social-messaging.ca-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.ca-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.ca-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), (Object)"social-messaging.ca-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.ca-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.ca-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), (Object)"social-messaging.eu-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), (Object)"social-messaging.eu-north-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), (Object)"social-messaging.eu-south-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), (Object)"social-messaging.eu-west-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), (Object)"social-messaging.eu-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-ca-central-1")).build(), (Object)"social-messaging-fips.ca-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-1")).build(), (Object)"social-messaging-fips.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-east-2")).build(), (Object)"social-messaging-fips.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("fips-us-west-2")).build(), (Object)"social-messaging-fips.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), (Object)"social-messaging.me-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), (Object)"social-messaging.me-south-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("mx-central-1")).build(), (Object)"social-messaging.mx-central-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), (Object)"social-messaging.sa-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), (Object)"social-messaging.us-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.us-east-1.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), (Object)"social-messaging.us-east-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.us-east-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), (Object)"social-messaging.us-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).tags(EndpointTag.of("dualstack"), EndpointTag.of("fips")).build(), (Object)"social-messaging-fips.us-west-2.api.aws").put((Object)ServiceEndpointKey.builder().region(Region.of("eusc-de-east-1")).build(), (Object)"social-messaging.eusc-de-east-1.api.aws").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

