/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.internal;

import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import sun.misc.Unsafe;

public class UnsafeUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Unsafe unsafe = UnsafeUtil.findUnsafe();

    private static Unsafe findUnsafe() {
        try {
            return (Unsafe)((Object)AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws ReflectiveOperationException, SecurityException {
                    ByteBuffer direct = ByteBuffer.allocateDirect(1);
                    cleanerMethod = direct.getClass().getDeclaredMethod("cleaner", new Class[0]);
                    cleanerMethod.setAccessible(true);
                    Object cleaner = cleanerMethod.invoke((Object)direct, new Object[0]);
                    cleanMethod = cleaner.getClass().getMethod("clean", new Class[0]);
                    return null;
                }
            }));
        }
        catch (PrivilegedActionException e) {
            Exception wrapped = e.getException();
            if (wrapped instanceof SecurityException) {
                throw (SecurityException)wrapped;
            }
            LOGGER.warn("sun.misc.Unsafe is not available. This will impact memory usage.", (Throwable)e);
            return null;
        }
    }

    public static void clean(ByteBuffer bb) throws Exception {
        if (unsafe != null && bb.isDirect()) {
            unsafe.invokeCleaner(bb);
        }
    }
}

