/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.endpoints.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class RuleArn {
    private final String partition;
    private final String service;
    private final String region;
    private final String accountId;
    private final List<String> resourceId;
    private static final int ARN_MIN_LENGTH = 8;
    private static final int ARN_PREFIX_LENGTH = 3;

    RuleArn(String partition, String service, String region, String accountId, List<String> resourceId) {
        this.partition = partition;
        this.service = service;
        this.region = region;
        this.accountId = accountId;
        this.resourceId = Collections.unmodifiableList(resourceId);
    }

    public static RuleArn parse(String arn) {
        if (arn == null || arn.length() < 8 || !arn.startsWith("arn:")) {
            return null;
        }
        int p0 = 3;
        int p1 = arn.indexOf(58, p0 + 1);
        if (p1 < 0) {
            return null;
        }
        int p2 = arn.indexOf(58, p1 + 1);
        if (p2 < 0) {
            return null;
        }
        int p3 = arn.indexOf(58, p2 + 1);
        if (p3 < 0) {
            return null;
        }
        int p4 = arn.indexOf(58, p3 + 1);
        if (p4 < 0) {
            return null;
        }
        String partition = arn.substring(p0 + 1, p1);
        String service = arn.substring(p1 + 1, p2);
        String region = arn.substring(p2 + 1, p3);
        String accountId = arn.substring(p3 + 1, p4);
        String resource = arn.substring(p4 + 1);
        if (partition.isEmpty() || service.isEmpty() || resource.isEmpty()) {
            return null;
        }
        return new RuleArn(partition, service, region, accountId, RuleArn.splitResource(resource));
    }

    private static List<String> splitResource(String resource) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        int length = resource.length();
        for (int i = 0; i < length; ++i) {
            char c = resource.charAt(i);
            if (c != ':' && c != '/') continue;
            result.add(resource.substring(start, i));
            start = i + 1;
        }
        result.add(resource.substring(start));
        return result;
    }

    public String partition() {
        return this.partition;
    }

    public String service() {
        return this.service;
    }

    public String region() {
        return this.region;
    }

    public String accountId() {
        return this.accountId;
    }

    public List<String> resourceId() {
        return this.resourceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleArn ruleArn = (RuleArn)o;
        return this.partition.equals(ruleArn.partition) && this.service.equals(ruleArn.service) && this.region.equals(ruleArn.region) && this.accountId.equals(ruleArn.accountId) && this.resourceId.equals(ruleArn.resourceId);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.service, this.region, this.accountId, this.resourceId);
    }

    public String toString() {
        return "Arn[partition=" + this.partition + ", service=" + this.service + ", region=" + this.region + ", accountId=" + this.accountId + ", resource=" + this.resourceId + ']';
    }
}

