/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.extensions;

import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClientExtension;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbExtensionContext;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.extensions.WriteModification;
import software.amazon.awssdk.enhanced.dynamodb.internal.EnhancedClientUtils;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
@ThreadSafe
public final class VersionedRecordExtension
implements DynamoDbEnhancedClientExtension {
    private static final Function<String, String> VERSIONED_RECORD_EXPRESSION_VALUE_KEY_MAPPER = key -> ":old_" + EnhancedClientUtils.cleanAttributeName(key) + "_value";
    private static final String CUSTOM_METADATA_KEY = "VersionedRecordExtension:VersionAttribute";
    private static final VersionAttribute VERSION_ATTRIBUTE = new VersionAttribute();
    private final long startAt;
    private final long incrementBy;

    private VersionedRecordExtension(Long startAt, Long incrementBy) {
        Validate.isNotNegativeOrNull((Long)startAt, (String)"startAt");
        if (incrementBy != null && incrementBy < 1L) {
            throw new IllegalArgumentException("incrementBy must be greater than 0.");
        }
        this.startAt = startAt != null ? startAt : 0L;
        this.incrementBy = incrementBy != null ? incrementBy : 1L;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public WriteModification beforeWrite(DynamoDbExtensionContext.BeforeWrite context) {
        Expression condition;
        AttributeValue newVersionValue;
        Optional<String> versionAttributeKey = context.tableMetadata().customMetadataObject(CUSTOM_METADATA_KEY, String.class);
        if (!versionAttributeKey.isPresent()) {
            return WriteModification.builder().build();
        }
        HashMap<String, AttributeValue> itemToTransform = new HashMap<String, AttributeValue>(context.items());
        String attributeKeyRef = EnhancedClientUtils.keyRef(versionAttributeKey.get());
        AttributeValue existingVersionValue = (AttributeValue)itemToTransform.get(versionAttributeKey.get());
        Long versionStartAtFromAnnotation = context.tableMetadata().customMetadataObject("VersionedRecordExtension:StartAt", Long.class).orElse(this.startAt);
        Long versionIncrementByFromAnnotation = context.tableMetadata().customMetadataObject("VersionedRecordExtension:IncrementBy", Long.class).orElse(this.incrementBy);
        if (this.isInitialVersion(existingVersionValue, versionStartAtFromAnnotation)) {
            newVersionValue = (AttributeValue)AttributeValue.builder().n(Long.toString(versionStartAtFromAnnotation + versionIncrementByFromAnnotation)).build();
            condition = Expression.builder().expression(String.format("attribute_not_exists(%s)", attributeKeyRef)).expressionNames(Collections.singletonMap(attributeKeyRef, versionAttributeKey.get())).build();
        } else {
            if (existingVersionValue.n() == null) {
                throw new IllegalArgumentException("Version attribute appears to be the wrong type. N is required.");
            }
            long existingVersion = Long.parseLong(existingVersionValue.n());
            String existingVersionValueKey = VERSIONED_RECORD_EXPRESSION_VALUE_KEY_MAPPER.apply(versionAttributeKey.get());
            long increment = versionIncrementByFromAnnotation;
            if (existingVersion > Long.MAX_VALUE - increment) {
                throw new IllegalStateException(String.format("Version overflow detected. Current version %d + increment %d would exceed Long.MAX_VALUE", existingVersion, increment));
            }
            newVersionValue = (AttributeValue)AttributeValue.builder().n(Long.toString(existingVersion + increment)).build();
            condition = Expression.builder().expression(String.format("%s = %s", attributeKeyRef, existingVersionValueKey)).expressionNames(Collections.singletonMap(attributeKeyRef, versionAttributeKey.get())).expressionValues(Collections.singletonMap(existingVersionValueKey, existingVersionValue)).build();
        }
        itemToTransform.put(versionAttributeKey.get(), newVersionValue);
        return WriteModification.builder().transformedItem(Collections.unmodifiableMap(itemToTransform)).additionalConditionalExpression(condition).build();
    }

    private boolean isInitialVersion(AttributeValue existingVersionValue, Long versionStartAtFromAnnotation) {
        if (existingVersionValue == null || EnhancedClientUtils.isNullAttributeValue(existingVersionValue)) {
            return true;
        }
        if (existingVersionValue.n() != null) {
            long currentVersion = Long.parseLong(existingVersionValue.n());
            Long effectiveStartAt = versionStartAtFromAnnotation != null ? versionStartAtFromAnnotation : this.startAt;
            return currentVersion == effectiveStartAt;
        }
        return false;
    }

    private static final class VersionAttribute
    implements StaticAttributeTag {
        private static final String START_AT_METADATA_KEY = "VersionedRecordExtension:StartAt";
        private static final String INCREMENT_BY_METADATA_KEY = "VersionedRecordExtension:IncrementBy";
        private final Long startAt;
        private final Long incrementBy;

        private VersionAttribute() {
            this.startAt = null;
            this.incrementBy = null;
        }

        private VersionAttribute(Long startAt, Long incrementBy) {
            this.startAt = startAt;
            this.incrementBy = incrementBy;
        }

        @Override
        public Consumer<StaticTableMetadata.Builder> modifyMetadata(String attributeName, AttributeValueType attributeValueType) {
            if (attributeValueType != AttributeValueType.N) {
                throw new IllegalArgumentException(String.format("Attribute '%s' of type %s is not a suitable type to be used as a version attribute. Only type 'N' is supported.", attributeName, attributeValueType.name()));
            }
            Validate.isNotNegativeOrNull((Long)this.startAt, (String)"startAt");
            if (this.incrementBy != null && this.incrementBy < 1L) {
                throw new IllegalArgumentException("incrementBy must be greater than 0.");
            }
            return metadata -> metadata.addCustomMetadataObject(VersionedRecordExtension.CUSTOM_METADATA_KEY, attributeName).addCustomMetadataObject(START_AT_METADATA_KEY, this.startAt).addCustomMetadataObject(INCREMENT_BY_METADATA_KEY, this.incrementBy).markAttributeAsKey(attributeName, attributeValueType);
        }
    }

    @NotThreadSafe
    public static final class Builder {
        private Long startAt;
        private Long incrementBy;

        private Builder() {
        }

        public Builder startAt(Long startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder incrementBy(Long incrementBy) {
            this.incrementBy = incrementBy;
            return this;
        }

        public VersionedRecordExtension build() {
            return new VersionedRecordExtension(this.startAt, this.incrementBy);
        }
    }

    public static final class AttributeTags {
        private AttributeTags() {
        }

        public static StaticAttributeTag versionAttribute() {
            return VERSION_ATTRIBUTE;
        }

        public static StaticAttributeTag versionAttribute(Long startAt, Long incrementBy) {
            return new VersionAttribute(startAt, incrementBy);
        }
    }
}

