/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.enhanced.dynamodb.AttributeConverter;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.EnhancedType;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.TypeConvertingVisitor;
import software.amazon.awssdk.enhanced.dynamodb.internal.converter.attribute.EnhancedAttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

@SdkInternalApi
@ThreadSafe
@Immutable
public class ListAttributeConverter<T extends Collection<?>>
implements AttributeConverter<T> {
    private final Delegate<T, ?> delegate;

    private ListAttributeConverter(Delegate<T, ?> delegate) {
        this.delegate = delegate;
    }

    public static <U> ListAttributeConverter<List<U>> create(AttributeConverter<U> elementConverter) {
        return ListAttributeConverter.builder(EnhancedType.listOf(elementConverter.type())).collectionConstructor(ArrayList::new).elementConverter(elementConverter).build();
    }

    public static <T extends Collection<U>, U> Builder<T, U> builder(EnhancedType<T> collectionType) {
        return new Builder(collectionType);
    }

    @Override
    public EnhancedType<T> type() {
        return this.delegate.type();
    }

    @Override
    public AttributeValueType attributeValueType() {
        return AttributeValueType.L;
    }

    @Override
    public AttributeValue transformFrom(T input) {
        return this.delegate.transformFrom(input);
    }

    @Override
    public T transformTo(AttributeValue input) {
        return (T)this.delegate.transformTo(input);
    }

    private static final class Delegate<T extends Collection<U>, U>
    implements AttributeConverter<T> {
        private final EnhancedType<T> type;
        private final Supplier<? extends T> collectionConstructor;
        private final AttributeConverter<U> elementConverter;

        private Delegate(Builder<T, U> builder) {
            this.type = ((Builder)builder).collectionType;
            this.collectionConstructor = ((Builder)builder).collectionConstructor;
            this.elementConverter = ((Builder)builder).elementConverter;
        }

        @Override
        public EnhancedType<T> type() {
            return this.type;
        }

        @Override
        public AttributeValueType attributeValueType() {
            return AttributeValueType.L;
        }

        @Override
        public AttributeValue transformFrom(T input) {
            return EnhancedAttributeValue.fromListOfAttributeValues(input.stream().map(this.elementConverter::transformFrom).collect(Collectors.toList())).toAttributeValue();
        }

        @Override
        public T transformTo(AttributeValue input) {
            return (T)((Collection)EnhancedAttributeValue.fromAttributeValue(input).convert(new TypeConvertingVisitor<T>(this.type.rawClass(), ListAttributeConverter.class){

                @Override
                public T convertSetOfStrings(List<String> value) {
                    return this.convertCollection(value, v -> (AttributeValue)AttributeValue.builder().s(v).build());
                }

                @Override
                public T convertSetOfNumbers(List<String> value) {
                    return this.convertCollection(value, v -> (AttributeValue)AttributeValue.builder().n(v).build());
                }

                @Override
                public T convertSetOfBytes(List<SdkBytes> value) {
                    return this.convertCollection(value, v -> (AttributeValue)AttributeValue.builder().b(v).build());
                }

                @Override
                public T convertListOfAttributeValues(List<AttributeValue> value) {
                    return this.convertCollection(value, Function.identity());
                }

                private <V> T convertCollection(Collection<V> collection, Function<V, AttributeValue> transformFrom) {
                    Collection result = (Collection)collectionConstructor.get();
                    collection.stream().map(transformFrom).map(elementConverter::transformTo).forEach(result::add);
                    return result;
                }
            }));
        }
    }

    @NotThreadSafe
    public static final class Builder<T extends Collection<U>, U> {
        private final EnhancedType<T> collectionType;
        private Supplier<? extends T> collectionConstructor;
        private AttributeConverter<U> elementConverter;

        private Builder(EnhancedType<T> collectionType) {
            this.collectionType = collectionType;
        }

        public Builder<T, U> collectionConstructor(Supplier<? extends T> collectionConstructor) {
            this.collectionConstructor = collectionConstructor;
            return this;
        }

        public Builder<T, U> elementConverter(AttributeConverter<U> elementConverter) {
            this.elementConverter = elementConverter;
            return this;
        }

        public ListAttributeConverter<T> build() {
            return new ListAttributeConverter(new Delegate(this));
        }
    }
}

