/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.mapper;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.enhanced.dynamodb.AttributeValueType;
import software.amazon.awssdk.enhanced.dynamodb.TableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.internal.extensions.AtomicCounterTag;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.UpdateBehaviorTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.Order;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticAttributeTag;
import software.amazon.awssdk.enhanced.dynamodb.mapper.StaticTableMetadata;
import software.amazon.awssdk.enhanced.dynamodb.mapper.UpdateBehavior;

@SdkPublicApi
@ThreadSafe
public final class StaticAttributeTags {
    private static final StaticAttributeTag PRIMARY_PARTITION_KEY_SINGLETON = new KeyAttributeTag((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexPartitionKey(TableMetadata.primaryIndexName(), ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType()));
    private static final StaticAttributeTag PRIMARY_SORT_KEY_SINGLETON = new KeyAttributeTag((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexSortKey(TableMetadata.primaryIndexName(), ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType()));

    private StaticAttributeTags() {
    }

    public static StaticAttributeTag primaryPartitionKey() {
        return PRIMARY_PARTITION_KEY_SINGLETON;
    }

    public static StaticAttributeTag primarySortKey() {
        return PRIMARY_SORT_KEY_SINGLETON;
    }

    public static StaticAttributeTag secondaryPartitionKey(String indexName) {
        return new KeyAttributeTag((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexPartitionKey(indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType()));
    }

    public static StaticAttributeTag secondaryPartitionKey(String indexName, Order order) {
        return new KeyAttributeTag((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexPartitionKey(indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType(), order));
    }

    public static StaticAttributeTag secondaryPartitionKey(Collection<String> indexNames) {
        return new KeyAttributeTag((tableMetadataBuilder, attribute) -> indexNames.forEach(indexName -> tableMetadataBuilder.addIndexPartitionKey((String)indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType())));
    }

    public static StaticAttributeTag secondaryPartitionKey(Collection<String> indexNames, Order order) {
        return new KeyAttributeTag((tableMetadataBuilder, attribute) -> indexNames.forEach(indexName -> tableMetadataBuilder.addIndexPartitionKey((String)indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType(), order)));
    }

    public static StaticAttributeTag secondarySortKey(String indexName) {
        return new KeyAttributeTag((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexSortKey(indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType()));
    }

    public static StaticAttributeTag secondarySortKey(String indexName, Order order) {
        return new KeyAttributeTag((tableMetadataBuilder, attribute) -> tableMetadataBuilder.addIndexSortKey(indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType(), order));
    }

    public static StaticAttributeTag secondarySortKey(Collection<String> indexNames) {
        return new KeyAttributeTag((tableMetadataBuilder, attribute) -> indexNames.forEach(indexName -> tableMetadataBuilder.addIndexSortKey((String)indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType())));
    }

    public static StaticAttributeTag secondarySortKey(Collection<String> indexNames, Order order) {
        return new KeyAttributeTag((tableMetadataBuilder, attribute) -> indexNames.forEach(indexName -> tableMetadataBuilder.addIndexSortKey((String)indexName, ((AttributeAndType)attribute).getAttributeName(), ((AttributeAndType)attribute).getAttributeValueType(), order)));
    }

    public static StaticAttributeTag updateBehavior(UpdateBehavior updateBehavior) {
        return UpdateBehaviorTag.fromUpdateBehavior(updateBehavior);
    }

    public static StaticAttributeTag atomicCounter(long delta, long startValue) {
        return AtomicCounterTag.fromValues(delta, startValue);
    }

    public static StaticAttributeTag atomicCounter() {
        return AtomicCounterTag.create();
    }

    private static class KeyAttributeTag
    implements StaticAttributeTag {
        private final BiConsumer<StaticTableMetadata.Builder, AttributeAndType> tableMetadataKeySetter;

        private KeyAttributeTag(BiConsumer<StaticTableMetadata.Builder, AttributeAndType> tableMetadataKeySetter) {
            this.tableMetadataKeySetter = tableMetadataKeySetter;
        }

        @Override
        public Consumer<StaticTableMetadata.Builder> modifyMetadata(String attributeName, AttributeValueType attributeValueType) {
            return metadata -> {
                if (attributeValueType.scalarAttributeType() == null) {
                    throw new IllegalArgumentException(String.format("Attribute '%s' of type %s is not a suitable type to be used as a key.", attributeName, attributeValueType.name()));
                }
                this.tableMetadataKeySetter.accept((StaticTableMetadata.Builder)metadata, new AttributeAndType(attributeName, attributeValueType));
            };
        }
    }

    private static class AttributeAndType {
        private final String attributeName;
        private final AttributeValueType attributeValueType;

        private AttributeAndType(String attributeName, AttributeValueType attributeValueType) {
            this.attributeName = attributeName;
            this.attributeValueType = attributeValueType;
        }

        private String getAttributeName() {
            return this.attributeName;
        }

        private AttributeValueType getAttributeValueType() {
            return this.attributeValueType;
        }
    }
}

