/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOf__doubleCopier;
import software.amazon.awssdk.services.pinpoint.model.MapOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.Session;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> APP_PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppPackageName").getter(Event.getter(Event::appPackageName)).setter(Event.setter(Builder::appPackageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppPackageName").build()}).build();
    private static final SdkField<String> APP_TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppTitle").getter(Event.getter(Event::appTitle)).setter(Event.setter(Builder::appTitle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppTitle").build()}).build();
    private static final SdkField<String> APP_VERSION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppVersionCode").getter(Event.getter(Event::appVersionCode)).setter(Event.setter(Builder::appVersionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppVersionCode").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(Event.getter(Event::attributes)).setter(Event.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_SDK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientSdkVersion").getter(Event.getter(Event::clientSdkVersion)).setter(Event.setter(Builder::clientSdkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientSdkVersion").build()}).build();
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventType").getter(Event.getter(Event::eventType)).setter(Event.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventType").build()}).build();
    private static final SdkField<Map<String, Double>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metrics").getter(Event.getter(Event::metrics)).setter(Event.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SDK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SdkName").getter(Event.getter(Event::sdkName)).setter(Event.setter(Builder::sdkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SdkName").build()}).build();
    private static final SdkField<Session> SESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Session").getter(Event.getter(Event::session)).setter(Event.setter(Builder::session)).constructor(Session::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Session").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timestamp").getter(Event.getter(Event::timestamp)).setter(Event.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_PACKAGE_NAME_FIELD, APP_TITLE_FIELD, APP_VERSION_CODE_FIELD, ATTRIBUTES_FIELD, CLIENT_SDK_VERSION_FIELD, EVENT_TYPE_FIELD, METRICS_FIELD, SDK_NAME_FIELD, SESSION_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Event.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String appPackageName;
    private final String appTitle;
    private final String appVersionCode;
    private final Map<String, String> attributes;
    private final String clientSdkVersion;
    private final String eventType;
    private final Map<String, Double> metrics;
    private final String sdkName;
    private final Session session;
    private final String timestamp;

    private Event(BuilderImpl builder) {
        this.appPackageName = builder.appPackageName;
        this.appTitle = builder.appTitle;
        this.appVersionCode = builder.appVersionCode;
        this.attributes = builder.attributes;
        this.clientSdkVersion = builder.clientSdkVersion;
        this.eventType = builder.eventType;
        this.metrics = builder.metrics;
        this.sdkName = builder.sdkName;
        this.session = builder.session;
        this.timestamp = builder.timestamp;
    }

    public final String appPackageName() {
        return this.appPackageName;
    }

    public final String appTitle() {
        return this.appTitle;
    }

    public final String appVersionCode() {
        return this.appVersionCode;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String clientSdkVersion() {
        return this.clientSdkVersion;
    }

    public final String eventType() {
        return this.eventType;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> metrics() {
        return this.metrics;
    }

    public final String sdkName() {
        return this.sdkName;
    }

    public final Session session() {
        return this.session;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.appPackageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.appTitle());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSdkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sdkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.session());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.appPackageName(), other.appPackageName()) && Objects.equals(this.appTitle(), other.appTitle()) && Objects.equals(this.appVersionCode(), other.appVersionCode()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.clientSdkVersion(), other.clientSdkVersion()) && Objects.equals(this.eventType(), other.eventType()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.sdkName(), other.sdkName()) && Objects.equals(this.session(), other.session()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"Event").add("AppPackageName", (Object)this.appPackageName()).add("AppTitle", (Object)this.appTitle()).add("AppVersionCode", (Object)this.appVersionCode()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("ClientSdkVersion", (Object)this.clientSdkVersion()).add("EventType", (Object)this.eventType()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("SdkName", (Object)this.sdkName()).add("Session", (Object)this.session()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppPackageName": {
                return Optional.ofNullable(clazz.cast(this.appPackageName()));
            }
            case "AppTitle": {
                return Optional.ofNullable(clazz.cast(this.appTitle()));
            }
            case "AppVersionCode": {
                return Optional.ofNullable(clazz.cast(this.appVersionCode()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "ClientSdkVersion": {
                return Optional.ofNullable(clazz.cast(this.clientSdkVersion()));
            }
            case "EventType": {
                return Optional.ofNullable(clazz.cast(this.eventType()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "SdkName": {
                return Optional.ofNullable(clazz.cast(this.sdkName()));
            }
            case "Session": {
                return Optional.ofNullable(clazz.cast(this.session()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AppPackageName", APP_PACKAGE_NAME_FIELD);
        map.put("AppTitle", APP_TITLE_FIELD);
        map.put("AppVersionCode", APP_VERSION_CODE_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("ClientSdkVersion", CLIENT_SDK_VERSION_FIELD);
        map.put("EventType", EVENT_TYPE_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("SdkName", SDK_NAME_FIELD);
        map.put("Session", SESSION_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String appPackageName;
        private String appTitle;
        private String appVersionCode;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String clientSdkVersion;
        private String eventType;
        private Map<String, Double> metrics = DefaultSdkAutoConstructMap.getInstance();
        private String sdkName;
        private Session session;
        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.appPackageName(model.appPackageName);
            this.appTitle(model.appTitle);
            this.appVersionCode(model.appVersionCode);
            this.attributes(model.attributes);
            this.clientSdkVersion(model.clientSdkVersion);
            this.eventType(model.eventType);
            this.metrics(model.metrics);
            this.sdkName(model.sdkName);
            this.session(model.session);
            this.timestamp(model.timestamp);
        }

        public final String getAppPackageName() {
            return this.appPackageName;
        }

        public final void setAppPackageName(String appPackageName) {
            this.appPackageName = appPackageName;
        }

        @Override
        public final Builder appPackageName(String appPackageName) {
            this.appPackageName = appPackageName;
            return this;
        }

        public final String getAppTitle() {
            return this.appTitle;
        }

        public final void setAppTitle(String appTitle) {
            this.appTitle = appTitle;
        }

        @Override
        public final Builder appTitle(String appTitle) {
            this.appTitle = appTitle;
            return this;
        }

        public final String getAppVersionCode() {
            return this.appVersionCode;
        }

        public final void setAppVersionCode(String appVersionCode) {
            this.appVersionCode = appVersionCode;
        }

        @Override
        public final Builder appVersionCode(String appVersionCode) {
            this.appVersionCode = appVersionCode;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = MapOf__stringCopier.copy(attributes);
            return this;
        }

        public final String getClientSdkVersion() {
            return this.clientSdkVersion;
        }

        public final void setClientSdkVersion(String clientSdkVersion) {
            this.clientSdkVersion = clientSdkVersion;
        }

        @Override
        public final Builder clientSdkVersion(String clientSdkVersion) {
            this.clientSdkVersion = clientSdkVersion;
            return this;
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        public final Map<String, Double> getMetrics() {
            if (this.metrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metrics;
        }

        public final void setMetrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Map<String, Double> metrics) {
            this.metrics = MapOf__doubleCopier.copy(metrics);
            return this;
        }

        public final String getSdkName() {
            return this.sdkName;
        }

        public final void setSdkName(String sdkName) {
            this.sdkName = sdkName;
        }

        @Override
        public final Builder sdkName(String sdkName) {
            this.sdkName = sdkName;
            return this;
        }

        public final Session.Builder getSession() {
            return this.session != null ? this.session.toBuilder() : null;
        }

        public final void setSession(Session.BuilderImpl session) {
            this.session = session != null ? session.build() : null;
        }

        @Override
        public final Builder session(Session session) {
            this.session = session;
            return this;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder appPackageName(String var1);

        public Builder appTitle(String var1);

        public Builder appVersionCode(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder clientSdkVersion(String var1);

        public Builder eventType(String var1);

        public Builder metrics(Map<String, Double> var1);

        public Builder sdkName(String var1);

        public Builder session(Session var1);

        default public Builder session(Consumer<Session.Builder> session) {
            return this.session((Session)((Session.Builder)Session.builder().applyMutation(session)).build());
        }

        public Builder timestamp(String var1);
    }
}

