/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.pinpoint.model.MapOfListOf__stringCopier;
import software.amazon.awssdk.services.pinpoint.model.MessageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SMSMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SMSMessage> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Body").getter(SMSMessage.getter(SMSMessage::body)).setter(SMSMessage.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Body").build()}).build();
    private static final SdkField<String> KEYWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Keyword").getter(SMSMessage.getter(SMSMessage::keyword)).setter(SMSMessage.setter(Builder::keyword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keyword").build()}).build();
    private static final SdkField<String> MEDIA_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MediaUrl").getter(SMSMessage.getter(SMSMessage::mediaUrl)).setter(SMSMessage.setter(Builder::mediaUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUrl").build()}).build();
    private static final SdkField<String> MESSAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageType").getter(SMSMessage.getter(SMSMessage::messageTypeAsString)).setter(SMSMessage.setter(Builder::messageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageType").build()}).build();
    private static final SdkField<String> ORIGINATION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OriginationNumber").getter(SMSMessage.getter(SMSMessage::originationNumber)).setter(SMSMessage.setter(Builder::originationNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginationNumber").build()}).build();
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderId").getter(SMSMessage.getter(SMSMessage::senderId)).setter(SMSMessage.setter(Builder::senderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()}).build();
    private static final SdkField<Map<String, List<String>>> SUBSTITUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Substitutions").getter(SMSMessage.getter(SMSMessage::substitutions)).setter(SMSMessage.setter(Builder::substitutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Substitutions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntityId").getter(SMSMessage.getter(SMSMessage::entityId)).setter(SMSMessage.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(SMSMessage.getter(SMSMessage::templateId)).setter(SMSMessage.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, KEYWORD_FIELD, MEDIA_URL_FIELD, MESSAGE_TYPE_FIELD, ORIGINATION_NUMBER_FIELD, SENDER_ID_FIELD, SUBSTITUTIONS_FIELD, ENTITY_ID_FIELD, TEMPLATE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SMSMessage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String keyword;
    private final String mediaUrl;
    private final String messageType;
    private final String originationNumber;
    private final String senderId;
    private final Map<String, List<String>> substitutions;
    private final String entityId;
    private final String templateId;

    private SMSMessage(BuilderImpl builder) {
        this.body = builder.body;
        this.keyword = builder.keyword;
        this.mediaUrl = builder.mediaUrl;
        this.messageType = builder.messageType;
        this.originationNumber = builder.originationNumber;
        this.senderId = builder.senderId;
        this.substitutions = builder.substitutions;
        this.entityId = builder.entityId;
        this.templateId = builder.templateId;
    }

    public final String body() {
        return this.body;
    }

    public final String keyword() {
        return this.keyword;
    }

    public final String mediaUrl() {
        return this.mediaUrl;
    }

    public final MessageType messageType() {
        return MessageType.fromValue(this.messageType);
    }

    public final String messageTypeAsString() {
        return this.messageType;
    }

    public final String originationNumber() {
        return this.originationNumber;
    }

    public final String senderId() {
        return this.senderId;
    }

    public final boolean hasSubstitutions() {
        return this.substitutions != null && !(this.substitutions instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> substitutions() {
        return this.substitutions;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyword());
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.originationNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubstitutions() ? this.substitutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SMSMessage)) {
            return false;
        }
        SMSMessage other = (SMSMessage)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.keyword(), other.keyword()) && Objects.equals(this.mediaUrl(), other.mediaUrl()) && Objects.equals(this.messageTypeAsString(), other.messageTypeAsString()) && Objects.equals(this.originationNumber(), other.originationNumber()) && Objects.equals(this.senderId(), other.senderId()) && this.hasSubstitutions() == other.hasSubstitutions() && Objects.equals(this.substitutions(), other.substitutions()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.templateId(), other.templateId());
    }

    public final String toString() {
        return ToString.builder((String)"SMSMessage").add("Body", (Object)this.body()).add("Keyword", (Object)this.keyword()).add("MediaUrl", (Object)this.mediaUrl()).add("MessageType", (Object)this.messageTypeAsString()).add("OriginationNumber", (Object)this.originationNumber()).add("SenderId", (Object)this.senderId()).add("Substitutions", this.hasSubstitutions() ? this.substitutions() : null).add("EntityId", (Object)this.entityId()).add("TemplateId", (Object)this.templateId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "Keyword": {
                return Optional.ofNullable(clazz.cast(this.keyword()));
            }
            case "MediaUrl": {
                return Optional.ofNullable(clazz.cast(this.mediaUrl()));
            }
            case "MessageType": {
                return Optional.ofNullable(clazz.cast(this.messageTypeAsString()));
            }
            case "OriginationNumber": {
                return Optional.ofNullable(clazz.cast(this.originationNumber()));
            }
            case "SenderId": {
                return Optional.ofNullable(clazz.cast(this.senderId()));
            }
            case "Substitutions": {
                return Optional.ofNullable(clazz.cast(this.substitutions()));
            }
            case "EntityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Body", BODY_FIELD);
        map.put("Keyword", KEYWORD_FIELD);
        map.put("MediaUrl", MEDIA_URL_FIELD);
        map.put("MessageType", MESSAGE_TYPE_FIELD);
        map.put("OriginationNumber", ORIGINATION_NUMBER_FIELD);
        map.put("SenderId", SENDER_ID_FIELD);
        map.put("Substitutions", SUBSTITUTIONS_FIELD);
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("TemplateId", TEMPLATE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SMSMessage, T> g) {
        return obj -> g.apply((SMSMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String keyword;
        private String mediaUrl;
        private String messageType;
        private String originationNumber;
        private String senderId;
        private Map<String, List<String>> substitutions = DefaultSdkAutoConstructMap.getInstance();
        private String entityId;
        private String templateId;

        private BuilderImpl() {
        }

        private BuilderImpl(SMSMessage model) {
            this.body(model.body);
            this.keyword(model.keyword);
            this.mediaUrl(model.mediaUrl);
            this.messageType(model.messageType);
            this.originationNumber(model.originationNumber);
            this.senderId(model.senderId);
            this.substitutions(model.substitutions);
            this.entityId(model.entityId);
            this.templateId(model.templateId);
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getKeyword() {
            return this.keyword;
        }

        public final void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        @Override
        public final Builder keyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public final String getMediaUrl() {
            return this.mediaUrl;
        }

        public final void setMediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
        }

        @Override
        public final Builder mediaUrl(String mediaUrl) {
            this.mediaUrl = mediaUrl;
            return this;
        }

        public final String getMessageType() {
            return this.messageType;
        }

        public final void setMessageType(String messageType) {
            this.messageType = messageType;
        }

        @Override
        public final Builder messageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        @Override
        public final Builder messageType(MessageType messageType) {
            this.messageType(messageType == null ? null : messageType.toString());
            return this;
        }

        public final String getOriginationNumber() {
            return this.originationNumber;
        }

        public final void setOriginationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
        }

        @Override
        public final Builder originationNumber(String originationNumber) {
            this.originationNumber = originationNumber;
            return this;
        }

        public final String getSenderId() {
            return this.senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getSubstitutions() {
            if (this.substitutions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.substitutions;
        }

        public final void setSubstitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
        }

        @Override
        public final Builder substitutions(Map<String, ? extends Collection<String>> substitutions) {
            this.substitutions = MapOfListOf__stringCopier.copy(substitutions);
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public SMSMessage build() {
            return new SMSMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SMSMessage> {
        public Builder body(String var1);

        public Builder keyword(String var1);

        public Builder mediaUrl(String var1);

        public Builder messageType(String var1);

        public Builder messageType(MessageType var1);

        public Builder originationNumber(String var1);

        public Builder senderId(String var1);

        public Builder substitutions(Map<String, ? extends Collection<String>> var1);

        public Builder entityId(String var1);

        public Builder templateId(String var1);
    }
}

